package zeenea.connector.powerbi.v2.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.powerbi.v2.client.pbix.Layout;

/**
 * Immutable implementation of {@link LayoutInformation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLayoutInformation.builder()}.
 */
@Generated(from = "LayoutInformation", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableLayoutInformation implements LayoutInformation {
  private final String workspaceId;
  private final String reportId;
  private final @Nullable Layout layout;

  private ImmutableLayoutInformation(
      String workspaceId,
      String reportId,
      @Nullable Layout layout) {
    this.workspaceId = workspaceId;
    this.reportId = reportId;
    this.layout = layout;
  }

  /**
   * @return The value of the {@code workspaceId} attribute
   */
  @Override
  public String workspaceId() {
    return workspaceId;
  }

  /**
   * @return The value of the {@code reportId} attribute
   */
  @Override
  public String reportId() {
    return reportId;
  }

  /**
   * @return The value of the {@code layout} attribute
   */
  @Override
  public @Nullable Layout layout() {
    return layout;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LayoutInformation#workspaceId() workspaceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workspaceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLayoutInformation withWorkspaceId(String value) {
    String newValue = Objects.requireNonNull(value, "workspaceId");
    if (this.workspaceId.equals(newValue)) return this;
    return new ImmutableLayoutInformation(newValue, this.reportId, this.layout);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LayoutInformation#reportId() reportId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reportId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLayoutInformation withReportId(String value) {
    String newValue = Objects.requireNonNull(value, "reportId");
    if (this.reportId.equals(newValue)) return this;
    return new ImmutableLayoutInformation(this.workspaceId, newValue, this.layout);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LayoutInformation#layout() layout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for layout (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLayoutInformation withLayout(@Nullable Layout value) {
    if (this.layout == value) return this;
    return new ImmutableLayoutInformation(this.workspaceId, this.reportId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLayoutInformation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLayoutInformation
        && equalTo(0, (ImmutableLayoutInformation) another);
  }

  private boolean equalTo(int synthetic, ImmutableLayoutInformation another) {
    return workspaceId.equals(another.workspaceId)
        && reportId.equals(another.reportId)
        && Objects.equals(layout, another.layout);
  }

  /**
   * Computes a hash code from attributes: {@code workspaceId}, {@code reportId}, {@code layout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + workspaceId.hashCode();
    h += (h << 5) + reportId.hashCode();
    h += (h << 5) + Objects.hashCode(layout);
    return h;
  }

  /**
   * Prints the immutable value {@code LayoutInformation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LayoutInformation{"
        + "workspaceId=" + workspaceId
        + ", reportId=" + reportId
        + ", layout=" + layout
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link LayoutInformation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LayoutInformation instance
   */
  public static ImmutableLayoutInformation copyOf(LayoutInformation instance) {
    if (instance instanceof ImmutableLayoutInformation) {
      return (ImmutableLayoutInformation) instance;
    }
    return ImmutableLayoutInformation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLayoutInformation ImmutableLayoutInformation}.
   * <pre>
   * ImmutableLayoutInformation.builder()
   *    .workspaceId(String) // required {@link LayoutInformation#workspaceId() workspaceId}
   *    .reportId(String) // required {@link LayoutInformation#reportId() reportId}
   *    .layout(zeenea.connector.powerbi.v2.client.pbix.Layout | null) // nullable {@link LayoutInformation#layout() layout}
   *    .build();
   * </pre>
   * @return A new ImmutableLayoutInformation builder
   */
  public static ImmutableLayoutInformation.Builder builder() {
    return new ImmutableLayoutInformation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLayoutInformation ImmutableLayoutInformation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LayoutInformation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKSPACE_ID = 0x1L;
    private static final long INIT_BIT_REPORT_ID = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String workspaceId;
    private @javax.annotation.Nullable String reportId;
    private @javax.annotation.Nullable Layout layout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LayoutInformation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LayoutInformation instance) {
      Objects.requireNonNull(instance, "instance");
      this.workspaceId(instance.workspaceId());
      this.reportId(instance.reportId());
      @Nullable Layout layoutValue = instance.layout();
      if (layoutValue != null) {
        layout(layoutValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LayoutInformation#workspaceId() workspaceId} attribute.
     * @param workspaceId The value for workspaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder workspaceId(String workspaceId) {
      this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId");
      initBits &= ~INIT_BIT_WORKSPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link LayoutInformation#reportId() reportId} attribute.
     * @param reportId The value for reportId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder reportId(String reportId) {
      this.reportId = Objects.requireNonNull(reportId, "reportId");
      initBits &= ~INIT_BIT_REPORT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link LayoutInformation#layout() layout} attribute.
     * @param layout The value for layout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder layout(@Nullable Layout layout) {
      this.layout = layout;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLayoutInformation ImmutableLayoutInformation}.
     * @return An immutable instance of LayoutInformation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLayoutInformation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLayoutInformation(workspaceId, reportId, layout);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKSPACE_ID) != 0) attributes.add("workspaceId");
      if ((initBits & INIT_BIT_REPORT_ID) != 0) attributes.add("reportId");
      return "Cannot build LayoutInformation, some of required attributes are not set " + attributes;
    }
  }
}
