/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.cache.BTreeFindResult;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeLeafPointer;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.BTreePointer;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CacheEntry;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.TableDesc;

public class ZeeCacheTable
implements Iterable<CacheEntry> {
    private final String name;
    private final CachePageLoader pageLoader;
    private final BTreePage rootPage;
    private final long size;

    private ZeeCacheTable(String name, CachePageLoader pageLoader, BTreePage rootPage, long size) {
        this.name = name;
        this.pageLoader = pageLoader;
        this.rootPage = rootPage;
        this.size = size;
    }

    static ZeeCacheTable of(String name, CachePageLoader pageLoader, TableDesc tableDesc) {
        BTreePage rootPage = pageLoader.page(tableDesc.rootPageNumber(), BTreePage.class);
        return new ZeeCacheTable(name, pageLoader, rootPage, tableDesc.size());
    }

    long size() {
        return this.size;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public CacheData get(String key) {
        return this.get(CacheData.of(key));
    }

    @Nullable
    public CacheData get(CacheData key) {
        BTreeLeafPointer pointer = BTreePointer.of(this.rootPage).findLeaf(key);
        BTreeLeafPage page = pointer.page();
        BTreeFindResult findResult = page.findEntry(key);
        return findResult.found() ? page.readValue(findResult.entryNumber()) : null;
    }

    @Nullable
    public String getString(CacheData key) {
        CacheData value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.stringValue();
    }

    @Nullable
    public String getString(String key) {
        return this.getString(CacheData.of(key));
    }

    @Override
    @NotNull
    public Iterator<CacheEntry> iterator() {
        return new CacheTableIterator(this.rootPage());
    }

    public void forEach(BiConsumer<CacheData, CacheData> action) {
        Objects.requireNonNull(action);
        for (CacheEntry e : this) {
            action.accept(e.key(), e.value());
        }
    }

    @Override
    public Spliterator<CacheEntry> spliterator() {
        return Spliterators.spliterator(this.iterator(), this.size, 0);
    }

    @NotNull
    public Stream<CacheEntry> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    BTreePage rootPage() {
        return this.rootPage;
    }

    private static class CacheTableIterator
    implements Iterator<CacheEntry> {
        private CacheEntry next;
        BTreeLeafPointer pagePtr;
        private int nextNumber;

        CacheTableIterator(BTreePage rootPage) {
            this.pagePtr = BTreePointer.of(rootPage).firstLeaf();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.pagePtr != null) {
                BTreeLeafPage leafPage = this.pagePtr.page();
                if (this.nextNumber < leafPage.entryCount()) {
                    this.next = leafPage.readEntry(this.nextNumber);
                    ++this.nextNumber;
                    return true;
                }
                this.pagePtr = this.pagePtr.nextLeaf();
                this.nextNumber = 0;
            }
            return false;
        }

        @Override
        public CacheEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            CacheEntry e = this.next;
            this.next = null;
            return e;
        }
    }
}

