/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.http.client.RestClient;
import zeenea.connector.commons.http.client.auth.AuthHandler;
import zeenea.connector.commons.http.client.auth.BasicAuthConfiguration;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.Pair;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceStringProperty;

public class BasicAuthHandler
implements AuthHandler {
    @NotNull
    private final List<Pair<String, String>> credentials;

    private BasicAuthHandler(@NotNull String username, @NotNull String password) {
        String creds = username + ":" + password;
        String basic = "Basic " + Base64.getEncoder().encodeToString(creds.getBytes(StandardCharsets.UTF_8));
        this.credentials = Collections.singletonList(Pair.of((Object)"Authorization", (Object)basic));
    }

    @NotNull
    public static BasicAuthHandler of(@NotNull String username, @NotNull String password) {
        return new BasicAuthHandler(username, password);
    }

    @Nullable
    public static BasicAuthHandler of(@NotNull PropertyValueMap configuration) {
        return configuration.get((SourceStringProperty)BasicAuthConfiguration.USERNAME).flatMap(username -> configuration.get((SourceStringProperty)BasicAuthConfiguration.PASSWORD).map(password -> BasicAuthHandler.of(username, password))).orElse(null);
    }

    @Override
    public List<Pair<String, String>> authenticationHeaders(TracingContext ctx, RestClient client) {
        return this.credentials;
    }
}

