package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PropertyType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePropertyType.builder()}.
 */
@Generated(from = "PropertyType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePropertyType
    implements PropertyType {
  private final String id;
  private final String rid;
  private final String apiName;
  private final DisplayMetadata displayMetadata;

  private ImmutablePropertyType(
      String id,
      String rid,
      String apiName,
      DisplayMetadata displayMetadata) {
    this.id = id;
    this.rid = rid;
    this.apiName = apiName;
    this.displayMetadata = displayMetadata;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("rid")
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code apiName} attribute
   */
  @JsonProperty("apiName")
  @Override
  public String getApiName() {
    return apiName;
  }

  /**
   * @return The value of the {@code displayMetadata} attribute
   */
  @JsonProperty("displayMetadata")
  @Override
  public DisplayMetadata getDisplayMetadata() {
    return displayMetadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PropertyType#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePropertyType withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutablePropertyType(newValue, this.rid, this.apiName, this.displayMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PropertyType#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePropertyType withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutablePropertyType(this.id, newValue, this.apiName, this.displayMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PropertyType#getApiName() apiName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apiName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePropertyType withApiName(String value) {
    String newValue = Objects.requireNonNull(value, "apiName");
    if (this.apiName.equals(newValue)) return this;
    return new ImmutablePropertyType(this.id, this.rid, newValue, this.displayMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PropertyType#getDisplayMetadata() displayMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePropertyType withDisplayMetadata(DisplayMetadata value) {
    if (this.displayMetadata == value) return this;
    DisplayMetadata newValue = Objects.requireNonNull(value, "displayMetadata");
    return new ImmutablePropertyType(this.id, this.rid, this.apiName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePropertyType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePropertyType
        && equalTo(0, (ImmutablePropertyType) another);
  }

  private boolean equalTo(int synthetic, ImmutablePropertyType another) {
    return id.equals(another.id)
        && rid.equals(another.rid)
        && apiName.equals(another.apiName)
        && displayMetadata.equals(another.displayMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rid}, {@code apiName}, {@code displayMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + apiName.hashCode();
    h += (h << 5) + displayMetadata.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PropertyType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PropertyType{"
        + "id=" + id
        + ", rid=" + rid
        + ", apiName=" + apiName
        + ", displayMetadata=" + displayMetadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PropertyType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PropertyType {
    @Nullable String id;
    @Nullable String rid;
    @Nullable String apiName;
    @Nullable DisplayMetadata displayMetadata;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("apiName")
    public void setApiName(String apiName) {
      this.apiName = apiName;
    }
    @JsonProperty("displayMetadata")
    public void setDisplayMetadata(DisplayMetadata displayMetadata) {
      this.displayMetadata = displayMetadata;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public String getApiName() { throw new UnsupportedOperationException(); }
    @Override
    public DisplayMetadata getDisplayMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePropertyType fromJson(Json json) {
    ImmutablePropertyType.Builder builder = ImmutablePropertyType.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.apiName != null) {
      builder.apiName(json.apiName);
    }
    if (json.displayMetadata != null) {
      builder.displayMetadata(json.displayMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PropertyType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PropertyType instance
   */
  public static ImmutablePropertyType copyOf(PropertyType instance) {
    if (instance instanceof ImmutablePropertyType) {
      return (ImmutablePropertyType) instance;
    }
    return ImmutablePropertyType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePropertyType ImmutablePropertyType}.
   * <pre>
   * ImmutablePropertyType.builder()
   *    .id(String) // required {@link PropertyType#getId() id}
   *    .rid(String) // required {@link PropertyType#getRid() rid}
   *    .apiName(String) // required {@link PropertyType#getApiName() apiName}
   *    .displayMetadata(zeenea.connector.palantir.foundry.client.model.ontology.DisplayMetadata) // required {@link PropertyType#getDisplayMetadata() displayMetadata}
   *    .build();
   * </pre>
   * @return A new ImmutablePropertyType builder
   */
  public static ImmutablePropertyType.Builder builder() {
    return new ImmutablePropertyType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePropertyType ImmutablePropertyType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PropertyType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_RID = 0x2L;
    private static final long INIT_BIT_API_NAME = 0x4L;
    private static final long INIT_BIT_DISPLAY_METADATA = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rid;
    private @Nullable String apiName;
    private @Nullable DisplayMetadata displayMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PropertyType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PropertyType instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.rid(instance.getRid());
      this.apiName(instance.getApiName());
      this.displayMetadata(instance.getDisplayMetadata());
      return this;
    }

    /**
     * Initializes the value for the {@link PropertyType#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PropertyType#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Initializes the value for the {@link PropertyType#getApiName() apiName} attribute.
     * @param apiName The value for apiName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apiName")
    public final Builder apiName(String apiName) {
      this.apiName = Objects.requireNonNull(apiName, "apiName");
      initBits &= ~INIT_BIT_API_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PropertyType#getDisplayMetadata() displayMetadata} attribute.
     * @param displayMetadata The value for displayMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayMetadata")
    public final Builder displayMetadata(DisplayMetadata displayMetadata) {
      this.displayMetadata = Objects.requireNonNull(displayMetadata, "displayMetadata");
      initBits &= ~INIT_BIT_DISPLAY_METADATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePropertyType ImmutablePropertyType}.
     * @return An immutable instance of PropertyType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePropertyType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePropertyType(id, rid, apiName, displayMetadata);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      if ((initBits & INIT_BIT_API_NAME) != 0) attributes.add("apiName");
      if ((initBits & INIT_BIT_DISPLAY_METADATA) != 0) attributes.add("displayMetadata");
      return "Cannot build PropertyType, some of required attributes are not set " + attributes;
    }
  }
}
