package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OntologyObjectType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOntologyObjectType.builder()}.
 */
@Generated(from = "OntologyObjectType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOntologyObjectType
    implements OntologyObjectType {
  private final String id;
  private final String rid;
  private final DisplayMetadata displayMetadata;
  private final Map<String, PropertyType> propertyTypes;

  private ImmutableOntologyObjectType(
      String id,
      String rid,
      DisplayMetadata displayMetadata,
      Map<String, PropertyType> propertyTypes) {
    this.id = id;
    this.rid = rid;
    this.displayMetadata = displayMetadata;
    this.propertyTypes = propertyTypes;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("rid")
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code displayMetadata} attribute
   */
  @JsonProperty("displayMetadata")
  @Override
  public DisplayMetadata getDisplayMetadata() {
    return displayMetadata;
  }

  /**
   * @return The value of the {@code propertyTypes} attribute
   */
  @JsonProperty("propertyTypes")
  @Override
  public Map<String, PropertyType> getPropertyTypes() {
    return propertyTypes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyObjectType#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyObjectType withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableOntologyObjectType(newValue, this.rid, this.displayMetadata, this.propertyTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyObjectType#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyObjectType withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutableOntologyObjectType(this.id, newValue, this.displayMetadata, this.propertyTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyObjectType#getDisplayMetadata() displayMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyObjectType withDisplayMetadata(DisplayMetadata value) {
    if (this.displayMetadata == value) return this;
    DisplayMetadata newValue = Objects.requireNonNull(value, "displayMetadata");
    return new ImmutableOntologyObjectType(this.id, this.rid, newValue, this.propertyTypes);
  }

  /**
   * Copy the current immutable object by replacing the {@link OntologyObjectType#getPropertyTypes() propertyTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the propertyTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyObjectType withPropertyTypes(Map<String, ? extends PropertyType> entries) {
    if (this.propertyTypes == entries) return this;
    Map<String, PropertyType> newValue = Map.copyOf(entries);
    return new ImmutableOntologyObjectType(this.id, this.rid, this.displayMetadata, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOntologyObjectType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOntologyObjectType
        && equalTo(0, (ImmutableOntologyObjectType) another);
  }

  private boolean equalTo(int synthetic, ImmutableOntologyObjectType another) {
    return id.equals(another.id)
        && rid.equals(another.rid)
        && displayMetadata.equals(another.displayMetadata)
        && propertyTypes.equals(another.propertyTypes);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rid}, {@code displayMetadata}, {@code propertyTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + displayMetadata.hashCode();
    h += (h << 5) + propertyTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OntologyObjectType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OntologyObjectType{"
        + "id=" + id
        + ", rid=" + rid
        + ", displayMetadata=" + displayMetadata
        + ", propertyTypes=" + propertyTypes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OntologyObjectType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements OntologyObjectType {
    @Nullable String id;
    @Nullable String rid;
    @Nullable DisplayMetadata displayMetadata;
    @Nullable Map<String, PropertyType> propertyTypes = Map.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("displayMetadata")
    public void setDisplayMetadata(DisplayMetadata displayMetadata) {
      this.displayMetadata = displayMetadata;
    }
    @JsonProperty("propertyTypes")
    public void setPropertyTypes(Map<String, PropertyType> propertyTypes) {
      this.propertyTypes = propertyTypes;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public DisplayMetadata getDisplayMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PropertyType> getPropertyTypes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOntologyObjectType fromJson(Json json) {
    ImmutableOntologyObjectType.Builder builder = ImmutableOntologyObjectType.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.displayMetadata != null) {
      builder.displayMetadata(json.displayMetadata);
    }
    if (json.propertyTypes != null) {
      builder.putAllPropertyTypes(json.propertyTypes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OntologyObjectType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OntologyObjectType instance
   */
  public static ImmutableOntologyObjectType copyOf(OntologyObjectType instance) {
    if (instance instanceof ImmutableOntologyObjectType) {
      return (ImmutableOntologyObjectType) instance;
    }
    return ImmutableOntologyObjectType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOntologyObjectType ImmutableOntologyObjectType}.
   * <pre>
   * ImmutableOntologyObjectType.builder()
   *    .id(String) // required {@link OntologyObjectType#getId() id}
   *    .rid(String) // required {@link OntologyObjectType#getRid() rid}
   *    .displayMetadata(zeenea.connector.palantir.foundry.client.model.ontology.DisplayMetadata) // required {@link OntologyObjectType#getDisplayMetadata() displayMetadata}
   *    .putPropertyTypes|putAllPropertyTypes(String =&gt; zeenea.connector.palantir.foundry.client.model.ontology.PropertyType) // {@link OntologyObjectType#getPropertyTypes() propertyTypes} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableOntologyObjectType builder
   */
  public static ImmutableOntologyObjectType.Builder builder() {
    return new ImmutableOntologyObjectType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOntologyObjectType ImmutableOntologyObjectType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OntologyObjectType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_RID = 0x2L;
    private static final long INIT_BIT_DISPLAY_METADATA = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String rid;
    private @Nullable DisplayMetadata displayMetadata;
    private Map<String, PropertyType> propertyTypes = new LinkedHashMap<String, PropertyType>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OntologyObjectType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OntologyObjectType instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.rid(instance.getRid());
      this.displayMetadata(instance.getDisplayMetadata());
      putAllPropertyTypes(instance.getPropertyTypes());
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyObjectType#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyObjectType#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyObjectType#getDisplayMetadata() displayMetadata} attribute.
     * @param displayMetadata The value for displayMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayMetadata")
    public final Builder displayMetadata(DisplayMetadata displayMetadata) {
      this.displayMetadata = Objects.requireNonNull(displayMetadata, "displayMetadata");
      initBits &= ~INIT_BIT_DISPLAY_METADATA;
      return this;
    }

    /**
     * Put one entry to the {@link OntologyObjectType#getPropertyTypes() propertyTypes} map.
     * @param key The key in the propertyTypes map
     * @param value The associated value in the propertyTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPropertyTypes(String key, PropertyType value) {
      this.propertyTypes.put(
          Objects.requireNonNull(key, "propertyTypes key"),
          Objects.requireNonNull(value, value == null ? "propertyTypes value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link OntologyObjectType#getPropertyTypes() propertyTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPropertyTypes(Map.Entry<String, ? extends PropertyType> entry) {
      String k = entry.getKey();
      PropertyType v = entry.getValue();
      this.propertyTypes.put(
          Objects.requireNonNull(k, "propertyTypes key"),
          Objects.requireNonNull(v, v == null ? "propertyTypes value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OntologyObjectType#getPropertyTypes() propertyTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the propertyTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("propertyTypes")
    public final Builder propertyTypes(Map<String, ? extends PropertyType> entries) {
      this.propertyTypes.clear();
      return putAllPropertyTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OntologyObjectType#getPropertyTypes() propertyTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the propertyTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllPropertyTypes(Map<String, ? extends PropertyType> entries) {
      for (Map.Entry<String, ? extends PropertyType> e : entries.entrySet()) {
        String k = e.getKey();
        PropertyType v = e.getValue();
        this.propertyTypes.put(
            Objects.requireNonNull(k, "propertyTypes key"),
            Objects.requireNonNull(v, v == null ? "propertyTypes value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOntologyObjectType ImmutableOntologyObjectType}.
     * @return An immutable instance of OntologyObjectType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOntologyObjectType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOntologyObjectType(id, rid, displayMetadata, Map.copyOf(propertyTypes));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      if ((initBits & INIT_BIT_DISPLAY_METADATA) != 0) attributes.add("displayMetadata");
      return "Cannot build OntologyObjectType, some of required attributes are not set " + attributes;
    }
  }
}
