package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OntologyEntityResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOntologyEntityResponse.builder()}.
 */
@Generated(from = "OntologyEntityResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOntologyEntityResponse
    implements OntologyEntityResponse {
  private final List<OntologyEntity> objectTypes;

  private ImmutableOntologyEntityResponse(ImmutableOntologyEntityResponse.Builder builder) {
    this.objectTypes = builder.objectTypesIsSet()
        ? createUnmodifiableList(true, builder.objectTypes)
        : createUnmodifiableList(false, createSafeList(OntologyEntityResponse.super.objectTypes(), false, false));
  }

  private ImmutableOntologyEntityResponse(List<OntologyEntity> objectTypes) {
    this.objectTypes = objectTypes;
  }

  /**
   * @return The value of the {@code objectTypes} attribute
   */
  @JsonProperty("objectTypes")
  @Override
  public List<OntologyEntity> objectTypes() {
    return objectTypes;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OntologyEntityResponse#objectTypes() objectTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyEntityResponse withObjectTypes(OntologyEntity... elements) {
    List<OntologyEntity> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableOntologyEntityResponse(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OntologyEntityResponse#objectTypes() objectTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyEntityResponse withObjectTypes(Iterable<? extends OntologyEntity> elements) {
    if (this.objectTypes == elements) return this;
    List<OntologyEntity> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableOntologyEntityResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOntologyEntityResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOntologyEntityResponse
        && equalTo(0, (ImmutableOntologyEntityResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableOntologyEntityResponse another) {
    return objectTypes.equals(another.objectTypes);
  }

  /**
   * Computes a hash code from attributes: {@code objectTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + objectTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OntologyEntityResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OntologyEntityResponse{"
        + "objectTypes=" + objectTypes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OntologyEntityResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements OntologyEntityResponse {
    @Nullable List<OntologyEntity> objectTypes = Collections.emptyList();
    boolean objectTypesIsSet;
    @JsonProperty("objectTypes")
    public void setObjectTypes(List<OntologyEntity> objectTypes) {
      this.objectTypes = objectTypes;
      this.objectTypesIsSet = null != objectTypes;
    }
    @Override
    public List<OntologyEntity> objectTypes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOntologyEntityResponse fromJson(Json json) {
    ImmutableOntologyEntityResponse.Builder builder = ImmutableOntologyEntityResponse.builder();
    if (json.objectTypesIsSet) {
      builder.addAllObjectTypes(json.objectTypes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OntologyEntityResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OntologyEntityResponse instance
   */
  public static ImmutableOntologyEntityResponse copyOf(OntologyEntityResponse instance) {
    if (instance instanceof ImmutableOntologyEntityResponse) {
      return (ImmutableOntologyEntityResponse) instance;
    }
    return ImmutableOntologyEntityResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOntologyEntityResponse ImmutableOntologyEntityResponse}.
   * <pre>
   * ImmutableOntologyEntityResponse.builder()
   *    .addObjectTypes|addAllObjectTypes(zeenea.connector.palantir.foundry.client.model.ontology.OntologyEntity) // {@link OntologyEntityResponse#objectTypes() objectTypes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOntologyEntityResponse builder
   */
  public static ImmutableOntologyEntityResponse.Builder builder() {
    return new ImmutableOntologyEntityResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOntologyEntityResponse ImmutableOntologyEntityResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OntologyEntityResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_OBJECT_TYPES = 0x1L;
    private long optBits;

    private List<OntologyEntity> objectTypes = new ArrayList<OntologyEntity>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OntologyEntityResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OntologyEntityResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllObjectTypes(instance.objectTypes());
      return this;
    }

    /**
     * Adds one element to {@link OntologyEntityResponse#objectTypes() objectTypes} list.
     * @param element A objectTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addObjectTypes(@Nullable OntologyEntity element) {
      this.objectTypes.add(element);
      optBits |= OPT_BIT_OBJECT_TYPES;
      return this;
    }

    /**
     * Adds elements to {@link OntologyEntityResponse#objectTypes() objectTypes} list.
     * @param elements An array of objectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addObjectTypes(OntologyEntity... elements) {
      for (OntologyEntity element : elements) {
        this.objectTypes.add(element);
      }
      optBits |= OPT_BIT_OBJECT_TYPES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OntologyEntityResponse#objectTypes() objectTypes} list.
     * @param elements An iterable of objectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("objectTypes")
    public final Builder objectTypes(Iterable<? extends OntologyEntity> elements) {
      this.objectTypes.clear();
      return addAllObjectTypes(elements);
    }

    /**
     * Adds elements to {@link OntologyEntityResponse#objectTypes() objectTypes} list.
     * @param elements An iterable of objectTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllObjectTypes(Iterable<? extends OntologyEntity> elements) {
      for (OntologyEntity element : elements) {
        this.objectTypes.add(element);
      }
      optBits |= OPT_BIT_OBJECT_TYPES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOntologyEntityResponse ImmutableOntologyEntityResponse}.
     * @return An immutable instance of OntologyEntityResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOntologyEntityResponse build() {
      return new ImmutableOntologyEntityResponse(this);
    }

    private boolean objectTypesIsSet() {
      return (optBits & OPT_BIT_OBJECT_TYPES) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
