package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OntologyEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOntologyEntity.builder()}.
 */
@Generated(from = "OntologyEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOntologyEntity
    implements OntologyEntity {
  private final String rid;
  private final OntologyObjectType objectType;
  private final List<OntologyDatasource> dataSources;

  private ImmutableOntologyEntity(
      String rid,
      OntologyObjectType objectType,
      List<OntologyDatasource> dataSources) {
    this.rid = rid;
    this.objectType = objectType;
    this.dataSources = dataSources;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("ontologyRid")
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code objectType} attribute
   */
  @JsonProperty("objectType")
  @Override
  public OntologyObjectType getObjectType() {
    return objectType;
  }

  /**
   * @return The value of the {@code dataSources} attribute
   */
  @JsonProperty("datasources")
  @Override
  public List<OntologyDatasource> getDataSources() {
    return dataSources;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyEntity#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyEntity withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutableOntologyEntity(newValue, this.objectType, this.dataSources);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyEntity#getObjectType() objectType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyEntity withObjectType(OntologyObjectType value) {
    if (this.objectType == value) return this;
    OntologyObjectType newValue = Objects.requireNonNull(value, "objectType");
    return new ImmutableOntologyEntity(this.rid, newValue, this.dataSources);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OntologyEntity#getDataSources() dataSources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyEntity withDataSources(OntologyDatasource... elements) {
    List<OntologyDatasource> newValue = List.of(elements);
    return new ImmutableOntologyEntity(this.rid, this.objectType, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OntologyEntity#getDataSources() dataSources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataSources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyEntity withDataSources(Iterable<? extends OntologyDatasource> elements) {
    if (this.dataSources == elements) return this;
    List<OntologyDatasource> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends OntologyDatasource>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableOntologyEntity(this.rid, this.objectType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOntologyEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOntologyEntity
        && equalTo(0, (ImmutableOntologyEntity) another);
  }

  private boolean equalTo(int synthetic, ImmutableOntologyEntity another) {
    return rid.equals(another.rid)
        && objectType.equals(another.objectType)
        && dataSources.equals(another.dataSources);
  }

  /**
   * Computes a hash code from attributes: {@code rid}, {@code objectType}, {@code dataSources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + objectType.hashCode();
    h += (h << 5) + dataSources.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OntologyEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OntologyEntity{"
        + "rid=" + rid
        + ", objectType=" + objectType
        + ", dataSources=" + dataSources
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OntologyEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OntologyEntity {
    @Nullable String rid;
    @Nullable OntologyObjectType objectType;
    @Nullable List<OntologyDatasource> dataSources = List.of();
    @JsonProperty("ontologyRid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("objectType")
    public void setObjectType(OntologyObjectType objectType) {
      this.objectType = objectType;
    }
    @JsonProperty("datasources")
    public void setDataSources(List<OntologyDatasource> dataSources) {
      this.dataSources = dataSources;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public OntologyObjectType getObjectType() { throw new UnsupportedOperationException(); }
    @Override
    public List<OntologyDatasource> getDataSources() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOntologyEntity fromJson(Json json) {
    ImmutableOntologyEntity.Builder builder = ImmutableOntologyEntity.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.objectType != null) {
      builder.objectType(json.objectType);
    }
    if (json.dataSources != null) {
      builder.addAllDataSources(json.dataSources);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OntologyEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OntologyEntity instance
   */
  public static ImmutableOntologyEntity copyOf(OntologyEntity instance) {
    if (instance instanceof ImmutableOntologyEntity) {
      return (ImmutableOntologyEntity) instance;
    }
    return ImmutableOntologyEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOntologyEntity ImmutableOntologyEntity}.
   * <pre>
   * ImmutableOntologyEntity.builder()
   *    .rid(String) // required {@link OntologyEntity#getRid() rid}
   *    .objectType(zeenea.connector.palantir.foundry.client.model.ontology.OntologyObjectType) // required {@link OntologyEntity#getObjectType() objectType}
   *    .addDataSources|addAllDataSources(zeenea.connector.palantir.foundry.client.model.ontology.OntologyDatasource) // {@link OntologyEntity#getDataSources() dataSources} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOntologyEntity builder
   */
  public static ImmutableOntologyEntity.Builder builder() {
    return new ImmutableOntologyEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOntologyEntity ImmutableOntologyEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OntologyEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RID = 0x1L;
    private static final long INIT_BIT_OBJECT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String rid;
    private @Nullable OntologyObjectType objectType;
    private List<OntologyDatasource> dataSources = new ArrayList<OntologyDatasource>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OntologyEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OntologyEntity instance) {
      Objects.requireNonNull(instance, "instance");
      this.rid(instance.getRid());
      this.objectType(instance.getObjectType());
      addAllDataSources(instance.getDataSources());
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyEntity#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ontologyRid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyEntity#getObjectType() objectType} attribute.
     * @param objectType The value for objectType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("objectType")
    public final Builder objectType(OntologyObjectType objectType) {
      this.objectType = Objects.requireNonNull(objectType, "objectType");
      initBits &= ~INIT_BIT_OBJECT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link OntologyEntity#getDataSources() dataSources} list.
     * @param element A dataSources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(OntologyDatasource element) {
      this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      return this;
    }

    /**
     * Adds elements to {@link OntologyEntity#getDataSources() dataSources} list.
     * @param elements An array of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDataSources(OntologyDatasource... elements) {
      for (OntologyDatasource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link OntologyEntity#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasources")
    public final Builder dataSources(Iterable<? extends OntologyDatasource> elements) {
      this.dataSources.clear();
      return addAllDataSources(elements);
    }

    /**
     * Adds elements to {@link OntologyEntity#getDataSources() dataSources} list.
     * @param elements An iterable of dataSources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDataSources(Iterable<? extends OntologyDatasource> elements) {
      for (OntologyDatasource element : elements) {
        this.dataSources.add(Objects.requireNonNull(element, "dataSources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOntologyEntity ImmutableOntologyEntity}.
     * @return An immutable instance of OntologyEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOntologyEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOntologyEntity(rid, objectType, List.copyOf(dataSources));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      if ((initBits & INIT_BIT_OBJECT_TYPE) != 0) attributes.add("objectType");
      return "Cannot build OntologyEntity, some of required attributes are not set " + attributes;
    }
  }
}
