package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OntologyDatasource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOntologyDatasource.builder()}.
 */
@Generated(from = "OntologyDatasource", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOntologyDatasource
    implements OntologyDatasource {
  private final String rid;
  private final OntologyDatasourceInfo datasource;

  private ImmutableOntologyDatasource(
      String rid,
      OntologyDatasourceInfo datasource) {
    this.rid = rid;
    this.datasource = datasource;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("rid")
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code datasource} attribute
   */
  @JsonProperty("datasource")
  @Override
  public OntologyDatasourceInfo getDatasource() {
    return datasource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyDatasource#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyDatasource withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutableOntologyDatasource(newValue, this.datasource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyDatasource#getDatasource() datasource} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasource
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyDatasource withDatasource(OntologyDatasourceInfo value) {
    if (this.datasource == value) return this;
    OntologyDatasourceInfo newValue = Objects.requireNonNull(value, "datasource");
    return new ImmutableOntologyDatasource(this.rid, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOntologyDatasource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOntologyDatasource
        && equalTo(0, (ImmutableOntologyDatasource) another);
  }

  private boolean equalTo(int synthetic, ImmutableOntologyDatasource another) {
    return rid.equals(another.rid)
        && datasource.equals(another.datasource);
  }

  /**
   * Computes a hash code from attributes: {@code rid}, {@code datasource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + datasource.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OntologyDatasource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OntologyDatasource{"
        + "rid=" + rid
        + ", datasource=" + datasource
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OntologyDatasource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements OntologyDatasource {
    @Nullable String rid;
    @Nullable OntologyDatasourceInfo datasource;
    @JsonProperty("rid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("datasource")
    public void setDatasource(OntologyDatasourceInfo datasource) {
      this.datasource = datasource;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public OntologyDatasourceInfo getDatasource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOntologyDatasource fromJson(Json json) {
    ImmutableOntologyDatasource.Builder builder = ImmutableOntologyDatasource.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.datasource != null) {
      builder.datasource(json.datasource);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OntologyDatasource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OntologyDatasource instance
   */
  public static ImmutableOntologyDatasource copyOf(OntologyDatasource instance) {
    if (instance instanceof ImmutableOntologyDatasource) {
      return (ImmutableOntologyDatasource) instance;
    }
    return ImmutableOntologyDatasource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOntologyDatasource ImmutableOntologyDatasource}.
   * <pre>
   * ImmutableOntologyDatasource.builder()
   *    .rid(String) // required {@link OntologyDatasource#getRid() rid}
   *    .datasource(zeenea.connector.palantir.foundry.client.model.ontology.OntologyDatasourceInfo) // required {@link OntologyDatasource#getDatasource() datasource}
   *    .build();
   * </pre>
   * @return A new ImmutableOntologyDatasource builder
   */
  public static ImmutableOntologyDatasource.Builder builder() {
    return new ImmutableOntologyDatasource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOntologyDatasource ImmutableOntologyDatasource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OntologyDatasource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RID = 0x1L;
    private static final long INIT_BIT_DATASOURCE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String rid;
    private @Nullable OntologyDatasourceInfo datasource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OntologyDatasource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OntologyDatasource instance) {
      Objects.requireNonNull(instance, "instance");
      this.rid(instance.getRid());
      this.datasource(instance.getDatasource());
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyDatasource#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyDatasource#getDatasource() datasource} attribute.
     * @param datasource The value for datasource 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasource")
    public final Builder datasource(OntologyDatasourceInfo datasource) {
      this.datasource = Objects.requireNonNull(datasource, "datasource");
      initBits &= ~INIT_BIT_DATASOURCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOntologyDatasource ImmutableOntologyDatasource}.
     * @return An immutable instance of OntologyDatasource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOntologyDatasource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOntologyDatasource(rid, datasource);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      if ((initBits & INIT_BIT_DATASOURCE) != 0) attributes.add("datasource");
      return "Cannot build OntologyDatasource, some of required attributes are not set " + attributes;
    }
  }
}
