package zeenea.connector.palantir.foundry.client.model.ontology;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OntologyDataset}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOntologyDataset.builder()}.
 */
@Generated(from = "OntologyDataset", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOntologyDataset
    implements OntologyDataset {
  private final String rid;
  private final Map<String, String> propertyMapping;

  private ImmutableOntologyDataset(String rid, Map<String, String> propertyMapping) {
    this.rid = rid;
    this.propertyMapping = propertyMapping;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("datasetRid")
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code propertyMapping} attribute
   */
  @JsonProperty("propertyMapping")
  @Override
  public Map<String, String> getPropertyMapping() {
    return propertyMapping;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OntologyDataset#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOntologyDataset withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutableOntologyDataset(newValue, this.propertyMapping);
  }

  /**
   * Copy the current immutable object by replacing the {@link OntologyDataset#getPropertyMapping() propertyMapping} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the propertyMapping map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOntologyDataset withPropertyMapping(Map<String, ? extends String> entries) {
    if (this.propertyMapping == entries) return this;
    Map<String, String> newValue = Map.copyOf(entries);
    return new ImmutableOntologyDataset(this.rid, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOntologyDataset} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOntologyDataset
        && equalTo(0, (ImmutableOntologyDataset) another);
  }

  private boolean equalTo(int synthetic, ImmutableOntologyDataset another) {
    return rid.equals(another.rid)
        && propertyMapping.equals(another.propertyMapping);
  }

  /**
   * Computes a hash code from attributes: {@code rid}, {@code propertyMapping}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + propertyMapping.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OntologyDataset} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OntologyDataset{"
        + "rid=" + rid
        + ", propertyMapping=" + propertyMapping
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OntologyDataset", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OntologyDataset {
    @Nullable String rid;
    @Nullable Map<String, String> propertyMapping = Map.of();
    @JsonProperty("datasetRid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("propertyMapping")
    public void setPropertyMapping(Map<String, String> propertyMapping) {
      this.propertyMapping = propertyMapping;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getPropertyMapping() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOntologyDataset fromJson(Json json) {
    ImmutableOntologyDataset.Builder builder = ImmutableOntologyDataset.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.propertyMapping != null) {
      builder.putAllPropertyMapping(json.propertyMapping);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OntologyDataset} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OntologyDataset instance
   */
  public static ImmutableOntologyDataset copyOf(OntologyDataset instance) {
    if (instance instanceof ImmutableOntologyDataset) {
      return (ImmutableOntologyDataset) instance;
    }
    return ImmutableOntologyDataset.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOntologyDataset ImmutableOntologyDataset}.
   * <pre>
   * ImmutableOntologyDataset.builder()
   *    .rid(String) // required {@link OntologyDataset#getRid() rid}
   *    .putPropertyMapping|putAllPropertyMapping(String =&gt; String) // {@link OntologyDataset#getPropertyMapping() propertyMapping} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableOntologyDataset builder
   */
  public static ImmutableOntologyDataset.Builder builder() {
    return new ImmutableOntologyDataset.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOntologyDataset ImmutableOntologyDataset}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OntologyDataset", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String rid;
    private Map<String, String> propertyMapping = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OntologyDataset} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OntologyDataset instance) {
      Objects.requireNonNull(instance, "instance");
      this.rid(instance.getRid());
      putAllPropertyMapping(instance.getPropertyMapping());
      return this;
    }

    /**
     * Initializes the value for the {@link OntologyDataset#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasetRid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Put one entry to the {@link OntologyDataset#getPropertyMapping() propertyMapping} map.
     * @param key The key in the propertyMapping map
     * @param value The associated value in the propertyMapping map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPropertyMapping(String key, String value) {
      this.propertyMapping.put(
          Objects.requireNonNull(key, "propertyMapping key"),
          Objects.requireNonNull(value, value == null ? "propertyMapping value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link OntologyDataset#getPropertyMapping() propertyMapping} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putPropertyMapping(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.propertyMapping.put(
          Objects.requireNonNull(k, "propertyMapping key"),
          Objects.requireNonNull(v, v == null ? "propertyMapping value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OntologyDataset#getPropertyMapping() propertyMapping} map. Nulls are not permitted
     * @param entries The entries that will be added to the propertyMapping map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("propertyMapping")
    public final Builder propertyMapping(Map<String, ? extends String> entries) {
      this.propertyMapping.clear();
      return putAllPropertyMapping(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OntologyDataset#getPropertyMapping() propertyMapping} map. Nulls are not permitted
     * @param entries The entries that will be added to the propertyMapping map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllPropertyMapping(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.propertyMapping.put(
            Objects.requireNonNull(k, "propertyMapping key"),
            Objects.requireNonNull(v, v == null ? "propertyMapping value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOntologyDataset ImmutableOntologyDataset}.
     * @return An immutable instance of OntologyDataset
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOntologyDataset build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOntologyDataset(rid, Map.copyOf(propertyMapping));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      return "Cannot build OntologyDataset, some of required attributes are not set " + attributes;
    }
  }
}
