package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Timestamp}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTimestamp.builder()}.
 */
@Generated(from = "Timestamp", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTimestamp implements Timestamp {
  private final @Nullable String time;

  private ImmutableTimestamp(@Nullable String time) {
    this.time = time;
  }

  /**
   * @return The value of the {@code time} attribute
   */
  @JsonProperty("time")
  @Override
  public @Nullable String getTime() {
    return time;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Timestamp#getTime() time} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTimestamp withTime(@Nullable String value) {
    if (Objects.equals(this.time, value)) return this;
    return new ImmutableTimestamp(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTimestamp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTimestamp
        && equalTo(0, (ImmutableTimestamp) another);
  }

  private boolean equalTo(int synthetic, ImmutableTimestamp another) {
    return Objects.equals(time, another.time);
  }

  /**
   * Computes a hash code from attributes: {@code time}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(time);
    return h;
  }

  /**
   * Prints the immutable value {@code Timestamp} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Timestamp{"
        + "time=" + time
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Timestamp", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Timestamp {
    @javax.annotation.Nullable String time;
    @JsonProperty("time")
    public void setTime(@Nullable String time) {
      this.time = time;
    }
    @Override
    public String getTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTimestamp fromJson(Json json) {
    ImmutableTimestamp.Builder builder = ImmutableTimestamp.builder();
    if (json.time != null) {
      builder.time(json.time);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Timestamp} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Timestamp instance
   */
  public static ImmutableTimestamp copyOf(Timestamp instance) {
    if (instance instanceof ImmutableTimestamp) {
      return (ImmutableTimestamp) instance;
    }
    return ImmutableTimestamp.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTimestamp ImmutableTimestamp}.
   * <pre>
   * ImmutableTimestamp.builder()
   *    .time(String | null) // nullable {@link Timestamp#getTime() time}
   *    .build();
   * </pre>
   * @return A new ImmutableTimestamp builder
   */
  public static ImmutableTimestamp.Builder builder() {
    return new ImmutableTimestamp.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTimestamp ImmutableTimestamp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Timestamp", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String time;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Timestamp} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Timestamp instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String timeValue = instance.getTime();
      if (timeValue != null) {
        time(timeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Timestamp#getTime() time} attribute.
     * @param time The value for time (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(@Nullable String time) {
      this.time = time;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTimestamp ImmutableTimestamp}.
     * @return An immutable instance of Timestamp
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTimestamp build() {
      return new ImmutableTimestamp(time);
    }
  }
}
