package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Resource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResource.builder()}.
 */
@Generated(from = "Resource", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableResource implements Resource {
  @NotNull
  private final String rid;
  private final @Nullable String name;
  private final @Nullable Timestamp created;
  private final @Nullable Timestamp modified;
  private final @Nullable String description;
  private final @Nullable String longDescription;
  private final @Nullable String path;
  private final @Nullable List<FoundryCollection> collections;
  private final @Nullable List<Marking> markings;

  private ImmutableResource(
      String rid,
      @Nullable String name,
      @Nullable Timestamp created,
      @Nullable Timestamp modified,
      @Nullable String description,
      @Nullable String longDescription,
      @Nullable String path,
      @Nullable List<FoundryCollection> collections,
      @Nullable List<Marking> markings) {
    this.rid = rid;
    this.name = name;
    this.created = created;
    this.modified = modified;
    this.description = description;
    this.longDescription = longDescription;
    this.path = path;
    this.collections = collections;
    this.markings = markings;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("rid")
  @NotNull
  @Override
  public String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable Timestamp getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @Override
  public @Nullable Timestamp getModified() {
    return modified;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code longDescription} attribute
   */
  @JsonProperty("longDescription")
  @Override
  public @Nullable String getLongDescription() {
    return longDescription;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code collections} attribute
   */
  @JsonProperty("namedCollections")
  @Override
  public @Nullable List<FoundryCollection> getCollections() {
    return collections;
  }

  /**
   * @return The value of the {@code markings} attribute
   */
  @JsonProperty("markings")
  @Override
  public @Nullable List<Marking> getMarkings() {
    return markings;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withRid(String value) {
    String newValue = Objects.requireNonNull(value, "rid");
    if (this.rid.equals(newValue)) return this;
    return new ImmutableResource(
        newValue,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableResource(
        this.rid,
        value,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withCreated(@Nullable Timestamp value) {
    if (this.created == value) return this;
    return new ImmutableResource(
        this.rid,
        this.name,
        value,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withModified(@Nullable Timestamp value) {
    if (this.modified == value) return this;
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        value,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        value,
        this.longDescription,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getLongDescription() longDescription} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for longDescription (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withLongDescription(@Nullable String value) {
    if (Objects.equals(this.longDescription, value)) return this;
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        value,
        this.path,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Resource#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResource withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        value,
        this.collections,
        this.markings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Resource#getCollections() collections}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResource withCollections(@Nullable FoundryCollection... elements) {
    if (elements == null) {
      return new ImmutableResource(
          this.rid,
          this.name,
          this.created,
          this.modified,
          this.description,
          this.longDescription,
          this.path,
          null,
          this.markings);
    }
    List<FoundryCollection> newValue = List.of(elements);
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        newValue,
        this.markings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Resource#getCollections() collections}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of collections elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResource withCollections(@Nullable Iterable<? extends FoundryCollection> elements) {
    if (this.collections == elements) return this;
    @Nullable List<FoundryCollection> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends FoundryCollection>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        newValue,
        this.markings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Resource#getMarkings() markings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResource withMarkings(@Nullable Marking... elements) {
    if (elements == null) {
      return new ImmutableResource(
          this.rid,
          this.name,
          this.created,
          this.modified,
          this.description,
          this.longDescription,
          this.path,
          this.collections,
          null);
    }
    List<Marking> newValue = List.of(elements);
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Resource#getMarkings() markings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of markings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResource withMarkings(@Nullable Iterable<? extends Marking> elements) {
    if (this.markings == elements) return this;
    @Nullable List<Marking> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Marking>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableResource(
        this.rid,
        this.name,
        this.created,
        this.modified,
        this.description,
        this.longDescription,
        this.path,
        this.collections,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResource
        && equalTo(0, (ImmutableResource) another);
  }

  private boolean equalTo(int synthetic, ImmutableResource another) {
    return rid.equals(another.rid)
        && Objects.equals(name, another.name)
        && Objects.equals(created, another.created)
        && Objects.equals(modified, another.modified)
        && Objects.equals(description, another.description)
        && Objects.equals(longDescription, another.longDescription)
        && Objects.equals(path, another.path)
        && Objects.equals(collections, another.collections)
        && Objects.equals(markings, another.markings);
  }

  /**
   * Computes a hash code from attributes: {@code rid}, {@code name}, {@code created}, {@code modified}, {@code description}, {@code longDescription}, {@code path}, {@code collections}, {@code markings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rid.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(modified);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(longDescription);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(collections);
    h += (h << 5) + Objects.hashCode(markings);
    return h;
  }

  /**
   * Prints the immutable value {@code Resource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Resource{"
        + "rid=" + rid
        + ", name=" + name
        + ", created=" + created
        + ", modified=" + modified
        + ", description=" + description
        + ", longDescription=" + longDescription
        + ", path=" + path
        + ", collections=" + collections
        + ", markings=" + markings
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Resource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Resource {
    @javax.annotation.Nullable String rid;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable Timestamp created;
    @javax.annotation.Nullable Timestamp modified;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String longDescription;
    @javax.annotation.Nullable String path;
    @javax.annotation.Nullable List<FoundryCollection> collections = null;
    @javax.annotation.Nullable List<Marking> markings = null;
    @JsonProperty("rid")
    public void setRid(String rid) {
      this.rid = rid;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable Timestamp created) {
      this.created = created;
    }
    @JsonProperty("modified")
    public void setModified(@Nullable Timestamp modified) {
      this.modified = modified;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("longDescription")
    public void setLongDescription(@Nullable String longDescription) {
      this.longDescription = longDescription;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("namedCollections")
    public void setCollections(@Nullable List<FoundryCollection> collections) {
      this.collections = collections;
    }
    @JsonProperty("markings")
    public void setMarkings(@Nullable List<Marking> markings) {
      this.markings = markings;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Timestamp getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Timestamp getModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getLongDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public List<FoundryCollection> getCollections() { throw new UnsupportedOperationException(); }
    @Override
    public List<Marking> getMarkings() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableResource fromJson(Json json) {
    ImmutableResource.Builder builder = ImmutableResource.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.modified != null) {
      builder.modified(json.modified);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.longDescription != null) {
      builder.longDescription(json.longDescription);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.collections != null) {
      builder.addAllCollections(json.collections);
    }
    if (json.markings != null) {
      builder.addAllMarkings(json.markings);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Resource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Resource instance
   */
  public static ImmutableResource copyOf(Resource instance) {
    if (instance instanceof ImmutableResource) {
      return (ImmutableResource) instance;
    }
    return ImmutableResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResource ImmutableResource}.
   * <pre>
   * ImmutableResource.builder()
   *    .rid(String) // required {@link Resource#getRid() rid}
   *    .name(String | null) // nullable {@link Resource#getName() name}
   *    .created(zeenea.connector.palantir.foundry.client.model.Timestamp | null) // nullable {@link Resource#getCreated() created}
   *    .modified(zeenea.connector.palantir.foundry.client.model.Timestamp | null) // nullable {@link Resource#getModified() modified}
   *    .description(String | null) // nullable {@link Resource#getDescription() description}
   *    .longDescription(String | null) // nullable {@link Resource#getLongDescription() longDescription}
   *    .path(String | null) // nullable {@link Resource#getPath() path}
   *    .collections(List&amp;lt;zeenea.connector.palantir.foundry.client.model.FoundryCollection&amp;gt; | null) // nullable {@link Resource#getCollections() collections}
   *    .markings(List&amp;lt;zeenea.connector.palantir.foundry.client.model.Marking&amp;gt; | null) // nullable {@link Resource#getMarkings() markings}
   *    .build();
   * </pre>
   * @return A new ImmutableResource builder
   */
  public static ImmutableResource.Builder builder() {
    return new ImmutableResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResource ImmutableResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Resource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String rid;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable Timestamp created;
    private @javax.annotation.Nullable Timestamp modified;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String longDescription;
    private @javax.annotation.Nullable String path;
    private List<FoundryCollection> collections = null;
    private List<Marking> markings = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Resource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      this.rid(instance.getRid());
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable Timestamp createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      @Nullable Timestamp modifiedValue = instance.getModified();
      if (modifiedValue != null) {
        modified(modifiedValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String longDescriptionValue = instance.getLongDescription();
      if (longDescriptionValue != null) {
        longDescription(longDescriptionValue);
      }
      @Nullable String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      @Nullable List<FoundryCollection> collectionsValue = instance.getCollections();
      if (collectionsValue != null) {
        addAllCollections(collectionsValue);
      }
      @Nullable List<Marking> markingsValue = instance.getMarkings();
      if (markingsValue != null) {
        addAllMarkings(markingsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getRid() rid} attribute.
     * @param rid The value for rid 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rid")
    public final Builder rid(String rid) {
      this.rid = Objects.requireNonNull(rid, "rid");
      initBits &= ~INIT_BIT_RID;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable Timestamp created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getModified() modified} attribute.
     * @param modified The value for modified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modified")
    public final Builder modified(@Nullable Timestamp modified) {
      this.modified = modified;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getLongDescription() longDescription} attribute.
     * @param longDescription The value for longDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("longDescription")
    public final Builder longDescription(@Nullable String longDescription) {
      this.longDescription = longDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link Resource#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Adds one element to {@link Resource#getCollections() collections} list.
     * @param element A collections element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCollections(FoundryCollection element) {
      if (this.collections == null) {
        this.collections = new ArrayList<FoundryCollection>();
      }
      this.collections.add(Objects.requireNonNull(element, "collections element"));
      return this;
    }

    /**
     * Adds elements to {@link Resource#getCollections() collections} list.
     * @param elements An array of collections elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCollections(FoundryCollection... elements) {
      if (this.collections == null) {
        this.collections = new ArrayList<FoundryCollection>();
      }
      for (FoundryCollection element : elements) {
        this.collections.add(Objects.requireNonNull(element, "collections element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Resource#getCollections() collections} list.
     * @param elements An iterable of collections elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("namedCollections")
    public final Builder collections(@Nullable Iterable<? extends FoundryCollection> elements) {
      if (elements == null) {
        this.collections = null;
        return this;
      }
      this.collections = new ArrayList<FoundryCollection>();
      return addAllCollections(elements);
    }

    /**
     * Adds elements to {@link Resource#getCollections() collections} list.
     * @param elements An iterable of collections elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCollections(Iterable<? extends FoundryCollection> elements) {
      Objects.requireNonNull(elements, "collections element");
      if (this.collections == null) {
        this.collections = new ArrayList<FoundryCollection>();
      }
      for (FoundryCollection element : elements) {
        this.collections.add(Objects.requireNonNull(element, "collections element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Resource#getMarkings() markings} list.
     * @param element A markings element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMarkings(Marking element) {
      if (this.markings == null) {
        this.markings = new ArrayList<Marking>();
      }
      this.markings.add(Objects.requireNonNull(element, "markings element"));
      return this;
    }

    /**
     * Adds elements to {@link Resource#getMarkings() markings} list.
     * @param elements An array of markings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMarkings(Marking... elements) {
      if (this.markings == null) {
        this.markings = new ArrayList<Marking>();
      }
      for (Marking element : elements) {
        this.markings.add(Objects.requireNonNull(element, "markings element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Resource#getMarkings() markings} list.
     * @param elements An iterable of markings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("markings")
    public final Builder markings(@Nullable Iterable<? extends Marking> elements) {
      if (elements == null) {
        this.markings = null;
        return this;
      }
      this.markings = new ArrayList<Marking>();
      return addAllMarkings(elements);
    }

    /**
     * Adds elements to {@link Resource#getMarkings() markings} list.
     * @param elements An iterable of markings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMarkings(Iterable<? extends Marking> elements) {
      Objects.requireNonNull(elements, "markings element");
      if (this.markings == null) {
        this.markings = new ArrayList<Marking>();
      }
      for (Marking element : elements) {
        this.markings.add(Objects.requireNonNull(element, "markings element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableResource ImmutableResource}.
     * @return An immutable instance of Resource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableResource(
          rid,
          name,
          created,
          modified,
          description,
          longDescription,
          path,
          collections == null ? null : List.copyOf(collections),
          markings == null ? null : List.copyOf(markings));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RID) != 0) attributes.add("rid");
      return "Cannot build Resource, some of required attributes are not set " + attributes;
    }
  }
}
