package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Marking}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMarking.builder()}.
 */
@Generated(from = "Marking", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMarking implements Marking {
  private final @Nullable String category;
  private final @Nullable String name;

  private ImmutableMarking(
      @Nullable String category,
      @Nullable String name) {
    this.category = category;
    this.name = name;
  }

  /**
   * @return The value of the {@code category} attribute
   */
  @JsonProperty("categoryName")
  @Override
  public @Nullable String getCategory() {
    return category;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("markingName")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Marking#getCategory() category} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for category (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMarking withCategory(@Nullable String value) {
    if (Objects.equals(this.category, value)) return this;
    return new ImmutableMarking(value, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Marking#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMarking withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMarking(this.category, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMarking} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMarking
        && equalTo(0, (ImmutableMarking) another);
  }

  private boolean equalTo(int synthetic, ImmutableMarking another) {
    return Objects.equals(category, another.category)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code category}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(category);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code Marking} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Marking{"
        + "category=" + category
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Marking", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Marking {
    @javax.annotation.Nullable String category;
    @javax.annotation.Nullable String name;
    @JsonProperty("categoryName")
    public void setCategory(@Nullable String category) {
      this.category = category;
    }
    @JsonProperty("markingName")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getCategory() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMarking fromJson(Json json) {
    ImmutableMarking.Builder builder = ImmutableMarking.builder();
    if (json.category != null) {
      builder.category(json.category);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Marking} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Marking instance
   */
  public static ImmutableMarking copyOf(Marking instance) {
    if (instance instanceof ImmutableMarking) {
      return (ImmutableMarking) instance;
    }
    return ImmutableMarking.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMarking ImmutableMarking}.
   * <pre>
   * ImmutableMarking.builder()
   *    .category(String | null) // nullable {@link Marking#getCategory() category}
   *    .name(String | null) // nullable {@link Marking#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableMarking builder
   */
  public static ImmutableMarking.Builder builder() {
    return new ImmutableMarking.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMarking ImmutableMarking}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Marking", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String category;
    private @javax.annotation.Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Marking} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Marking instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String categoryValue = instance.getCategory();
      if (categoryValue != null) {
        category(categoryValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Marking#getCategory() category} attribute.
     * @param category The value for category (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("categoryName")
    public final Builder category(@Nullable String category) {
      this.category = category;
      return this;
    }

    /**
     * Initializes the value for the {@link Marking#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("markingName")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMarking ImmutableMarking}.
     * @return An immutable instance of Marking
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMarking build() {
      return new ImmutableMarking(category, name);
    }
  }
}
