package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link FoundryCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFoundryCollection.builder()}.
 */
@Generated(from = "FoundryCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFoundryCollection
    implements FoundryCollection {
  private final @Nullable String rid;
  private final @Nullable String name;

  private ImmutableFoundryCollection(
      @Nullable String rid,
      @Nullable String name) {
    this.rid = rid;
    this.name = name;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("rid")
  @Override
  public @Nullable String getRid() {
    return rid;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryCollection#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryCollection withRid(@Nullable String value) {
    if (Objects.equals(this.rid, value)) return this;
    return new ImmutableFoundryCollection(value, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryCollection#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryCollection withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableFoundryCollection(this.rid, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFoundryCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFoundryCollection
        && equalTo(0, (ImmutableFoundryCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableFoundryCollection another) {
    return Objects.equals(rid, another.rid)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code rid}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(rid);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code FoundryCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FoundryCollection{"
        + "rid=" + rid
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FoundryCollection", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FoundryCollection {
    @javax.annotation.Nullable String rid;
    @javax.annotation.Nullable String name;
    @JsonProperty("rid")
    public void setRid(@Nullable String rid) {
      this.rid = rid;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFoundryCollection fromJson(Json json) {
    ImmutableFoundryCollection.Builder builder = ImmutableFoundryCollection.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FoundryCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FoundryCollection instance
   */
  public static ImmutableFoundryCollection copyOf(FoundryCollection instance) {
    if (instance instanceof ImmutableFoundryCollection) {
      return (ImmutableFoundryCollection) instance;
    }
    return ImmutableFoundryCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFoundryCollection ImmutableFoundryCollection}.
   * <pre>
   * ImmutableFoundryCollection.builder()
   *    .rid(String | null) // nullable {@link FoundryCollection#getRid() rid}
   *    .name(String | null) // nullable {@link FoundryCollection#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableFoundryCollection builder
   */
  public static ImmutableFoundryCollection.Builder builder() {
    return new ImmutableFoundryCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFoundryCollection ImmutableFoundryCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FoundryCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String rid;
    private @javax.annotation.Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FoundryCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FoundryCollection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String ridValue = instance.getRid();
      if (ridValue != null) {
        rid(ridValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryCollection#getRid() rid} attribute.
     * @param rid The value for rid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rid")
    public final Builder rid(@Nullable String rid) {
      this.rid = rid;
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryCollection#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFoundryCollection ImmutableFoundryCollection}.
     * @return An immutable instance of FoundryCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFoundryCollection build() {
      return new ImmutableFoundryCollection(rid, name);
    }
  }
}
