package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link FieldSchema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldSchema.builder()}.
 */
@Generated(from = "FieldSchema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFieldSchema implements FieldSchema {
  private final @Nullable String type;
  private final @Nullable String name;
  private final @Nullable Boolean nullable;
  private final @Nullable FieldSchemaArraySubtype arraySubtype;

  private ImmutableFieldSchema(
      @Nullable String type,
      @Nullable String name,
      @Nullable Boolean nullable,
      @Nullable FieldSchemaArraySubtype arraySubtype) {
    this.type = type;
    this.name = name;
    this.nullable = nullable;
    this.arraySubtype = arraySubtype;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public @Nullable Boolean getNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code arraySubtype} attribute
   */
  @JsonProperty("arraySubtype")
  @Override
  public @Nullable FieldSchemaArraySubtype getArraySubtype() {
    return arraySubtype;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldSchema#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldSchema withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableFieldSchema(value, this.name, this.nullable, this.arraySubtype);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldSchema#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldSchema withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableFieldSchema(this.type, value, this.nullable, this.arraySubtype);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldSchema#getNullable() nullable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldSchema withNullable(@Nullable Boolean value) {
    if (Objects.equals(this.nullable, value)) return this;
    return new ImmutableFieldSchema(this.type, this.name, value, this.arraySubtype);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldSchema#getArraySubtype() arraySubtype} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arraySubtype (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldSchema withArraySubtype(@Nullable FieldSchemaArraySubtype value) {
    if (this.arraySubtype == value) return this;
    return new ImmutableFieldSchema(this.type, this.name, this.nullable, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldSchema
        && equalTo(0, (ImmutableFieldSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableFieldSchema another) {
    return Objects.equals(type, another.type)
        && Objects.equals(name, another.name)
        && Objects.equals(nullable, another.nullable)
        && Objects.equals(arraySubtype, another.arraySubtype);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code nullable}, {@code arraySubtype}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(arraySubtype);
    return h;
  }

  /**
   * Prints the immutable value {@code FieldSchema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FieldSchema{"
        + "type=" + type
        + ", name=" + name
        + ", nullable=" + nullable
        + ", arraySubtype=" + arraySubtype
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FieldSchema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FieldSchema {
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable Boolean nullable;
    @javax.annotation.Nullable FieldSchemaArraySubtype arraySubtype;
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("nullable")
    public void setNullable(@Nullable Boolean nullable) {
      this.nullable = nullable;
    }
    @JsonProperty("arraySubtype")
    public void setArraySubtype(@Nullable FieldSchemaArraySubtype arraySubtype) {
      this.arraySubtype = arraySubtype;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNullable() { throw new UnsupportedOperationException(); }
    @Override
    public FieldSchemaArraySubtype getArraySubtype() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFieldSchema fromJson(Json json) {
    ImmutableFieldSchema.Builder builder = ImmutableFieldSchema.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nullable != null) {
      builder.nullable(json.nullable);
    }
    if (json.arraySubtype != null) {
      builder.arraySubtype(json.arraySubtype);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FieldSchema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldSchema instance
   */
  public static ImmutableFieldSchema copyOf(FieldSchema instance) {
    if (instance instanceof ImmutableFieldSchema) {
      return (ImmutableFieldSchema) instance;
    }
    return ImmutableFieldSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldSchema ImmutableFieldSchema}.
   * <pre>
   * ImmutableFieldSchema.builder()
   *    .type(String | null) // nullable {@link FieldSchema#getType() type}
   *    .name(String | null) // nullable {@link FieldSchema#getName() name}
   *    .nullable(Boolean | null) // nullable {@link FieldSchema#getNullable() nullable}
   *    .arraySubtype(zeenea.connector.palantir.foundry.client.model.FieldSchemaArraySubtype | null) // nullable {@link FieldSchema#getArraySubtype() arraySubtype}
   *    .build();
   * </pre>
   * @return A new ImmutableFieldSchema builder
   */
  public static ImmutableFieldSchema.Builder builder() {
    return new ImmutableFieldSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldSchema ImmutableFieldSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldSchema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable Boolean nullable;
    private @javax.annotation.Nullable FieldSchemaArraySubtype arraySubtype;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldSchema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldSchema instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable Boolean nullableValue = instance.getNullable();
      if (nullableValue != null) {
        nullable(nullableValue);
      }
      @Nullable FieldSchemaArraySubtype arraySubtypeValue = instance.getArraySubtype();
      if (arraySubtypeValue != null) {
        arraySubtype(arraySubtypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FieldSchema#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldSchema#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldSchema#getNullable() nullable} attribute.
     * @param nullable The value for nullable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    public final Builder nullable(@Nullable Boolean nullable) {
      this.nullable = nullable;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldSchema#getArraySubtype() arraySubtype} attribute.
     * @param arraySubtype The value for arraySubtype (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("arraySubtype")
    public final Builder arraySubtype(@Nullable FieldSchemaArraySubtype arraySubtype) {
      this.arraySubtype = arraySubtype;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldSchema ImmutableFieldSchema}.
     * @return An immutable instance of FieldSchema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldSchema build() {
      return new ImmutableFieldSchema(type, name, nullable, arraySubtype);
    }
  }
}
