package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DatasetSchemaResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetSchemaResponse.builder()}.
 */
@Generated(from = "DatasetSchemaResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDatasetSchemaResponse
    implements DatasetSchemaResponse {
  private final @Nullable DatasetSchema schema;

  private ImmutableDatasetSchemaResponse(
      @Nullable DatasetSchema schema) {
    this.schema = schema;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @Override
  public @Nullable DatasetSchema getSchema() {
    return schema;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetSchemaResponse#getSchema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetSchemaResponse withSchema(@Nullable DatasetSchema value) {
    if (this.schema == value) return this;
    return new ImmutableDatasetSchemaResponse(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetSchemaResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetSchemaResponse
        && equalTo(0, (ImmutableDatasetSchemaResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetSchemaResponse another) {
    return Objects.equals(schema, another.schema);
  }

  /**
   * Computes a hash code from attributes: {@code schema}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(schema);
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetSchemaResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetSchemaResponse{"
        + "schema=" + schema
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DatasetSchemaResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DatasetSchemaResponse {
    @javax.annotation.Nullable DatasetSchema schema;
    @JsonProperty("schema")
    public void setSchema(@Nullable DatasetSchema schema) {
      this.schema = schema;
    }
    @Override
    public DatasetSchema getSchema() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetSchemaResponse fromJson(Json json) {
    ImmutableDatasetSchemaResponse.Builder builder = ImmutableDatasetSchemaResponse.builder();
    if (json.schema != null) {
      builder.schema(json.schema);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DatasetSchemaResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetSchemaResponse instance
   */
  public static ImmutableDatasetSchemaResponse copyOf(DatasetSchemaResponse instance) {
    if (instance instanceof ImmutableDatasetSchemaResponse) {
      return (ImmutableDatasetSchemaResponse) instance;
    }
    return ImmutableDatasetSchemaResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetSchemaResponse ImmutableDatasetSchemaResponse}.
   * <pre>
   * ImmutableDatasetSchemaResponse.builder()
   *    .schema(zeenea.connector.palantir.foundry.client.model.DatasetSchema | null) // nullable {@link DatasetSchemaResponse#getSchema() schema}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetSchemaResponse builder
   */
  public static ImmutableDatasetSchemaResponse.Builder builder() {
    return new ImmutableDatasetSchemaResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetSchemaResponse ImmutableDatasetSchemaResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetSchemaResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable DatasetSchema schema;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetSchemaResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetSchemaResponse instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable DatasetSchema schemaValue = instance.getSchema();
      if (schemaValue != null) {
        schema(schemaValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetSchemaResponse#getSchema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    public final Builder schema(@Nullable DatasetSchema schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetSchemaResponse ImmutableDatasetSchemaResponse}.
     * @return An immutable instance of DatasetSchemaResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetSchemaResponse build() {
      return new ImmutableDatasetSchemaResponse(schema);
    }
  }
}
