package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DatasetSchema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetSchema.builder()}.
 */
@Generated(from = "DatasetSchema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDatasetSchema
    implements DatasetSchema {
  private final @Nullable List<FieldSchema> fieldSchemas;
  private final @Nullable DatasetCustomMetadata customMetadata;

  private ImmutableDatasetSchema(
      @Nullable List<FieldSchema> fieldSchemas,
      @Nullable DatasetCustomMetadata customMetadata) {
    this.fieldSchemas = fieldSchemas;
    this.customMetadata = customMetadata;
  }

  /**
   * @return The value of the {@code fieldSchemas} attribute
   */
  @JsonProperty("fieldSchemaList")
  @Override
  public @Nullable List<FieldSchema> getFieldSchemas() {
    return fieldSchemas;
  }

  /**
   * @return The value of the {@code customMetadata} attribute
   */
  @JsonProperty("customMetadata")
  @Override
  public @Nullable DatasetCustomMetadata getCustomMetadata() {
    return customMetadata;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DatasetSchema#getFieldSchemas() fieldSchemas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatasetSchema withFieldSchemas(@Nullable FieldSchema... elements) {
    if (elements == null) {
      return new ImmutableDatasetSchema(null, this.customMetadata);
    }
    List<FieldSchema> newValue = List.of(elements);
    return new ImmutableDatasetSchema(newValue, this.customMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DatasetSchema#getFieldSchemas() fieldSchemas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fieldSchemas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatasetSchema withFieldSchemas(@Nullable Iterable<? extends FieldSchema> elements) {
    if (this.fieldSchemas == elements) return this;
    @Nullable List<FieldSchema> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends FieldSchema>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDatasetSchema(newValue, this.customMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetSchema#getCustomMetadata() customMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customMetadata (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetSchema withCustomMetadata(@Nullable DatasetCustomMetadata value) {
    if (this.customMetadata == value) return this;
    return new ImmutableDatasetSchema(this.fieldSchemas, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetSchema
        && equalTo(0, (ImmutableDatasetSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetSchema another) {
    return Objects.equals(fieldSchemas, another.fieldSchemas)
        && Objects.equals(customMetadata, another.customMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code fieldSchemas}, {@code customMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(fieldSchemas);
    h += (h << 5) + Objects.hashCode(customMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetSchema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetSchema{"
        + "fieldSchemas=" + fieldSchemas
        + ", customMetadata=" + customMetadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DatasetSchema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DatasetSchema {
    @javax.annotation.Nullable List<FieldSchema> fieldSchemas = null;
    @javax.annotation.Nullable DatasetCustomMetadata customMetadata;
    @JsonProperty("fieldSchemaList")
    public void setFieldSchemas(@Nullable List<FieldSchema> fieldSchemas) {
      this.fieldSchemas = fieldSchemas;
    }
    @JsonProperty("customMetadata")
    public void setCustomMetadata(@Nullable DatasetCustomMetadata customMetadata) {
      this.customMetadata = customMetadata;
    }
    @Override
    public List<FieldSchema> getFieldSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public DatasetCustomMetadata getCustomMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetSchema fromJson(Json json) {
    ImmutableDatasetSchema.Builder builder = ImmutableDatasetSchema.builder();
    if (json.fieldSchemas != null) {
      builder.addAllFieldSchemas(json.fieldSchemas);
    }
    if (json.customMetadata != null) {
      builder.customMetadata(json.customMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DatasetSchema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetSchema instance
   */
  public static ImmutableDatasetSchema copyOf(DatasetSchema instance) {
    if (instance instanceof ImmutableDatasetSchema) {
      return (ImmutableDatasetSchema) instance;
    }
    return ImmutableDatasetSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetSchema ImmutableDatasetSchema}.
   * <pre>
   * ImmutableDatasetSchema.builder()
   *    .fieldSchemas(List&amp;lt;zeenea.connector.palantir.foundry.client.model.FieldSchema&amp;gt; | null) // nullable {@link DatasetSchema#getFieldSchemas() fieldSchemas}
   *    .customMetadata(zeenea.connector.palantir.foundry.client.model.DatasetCustomMetadata | null) // nullable {@link DatasetSchema#getCustomMetadata() customMetadata}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetSchema builder
   */
  public static ImmutableDatasetSchema.Builder builder() {
    return new ImmutableDatasetSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetSchema ImmutableDatasetSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetSchema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<FieldSchema> fieldSchemas = null;
    private @javax.annotation.Nullable DatasetCustomMetadata customMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetSchema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetSchema instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<FieldSchema> fieldSchemasValue = instance.getFieldSchemas();
      if (fieldSchemasValue != null) {
        addAllFieldSchemas(fieldSchemasValue);
      }
      @Nullable DatasetCustomMetadata customMetadataValue = instance.getCustomMetadata();
      if (customMetadataValue != null) {
        customMetadata(customMetadataValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link DatasetSchema#getFieldSchemas() fieldSchemas} list.
     * @param element A fieldSchemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFieldSchemas(FieldSchema element) {
      if (this.fieldSchemas == null) {
        this.fieldSchemas = new ArrayList<FieldSchema>();
      }
      this.fieldSchemas.add(Objects.requireNonNull(element, "fieldSchemas element"));
      return this;
    }

    /**
     * Adds elements to {@link DatasetSchema#getFieldSchemas() fieldSchemas} list.
     * @param elements An array of fieldSchemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFieldSchemas(FieldSchema... elements) {
      if (this.fieldSchemas == null) {
        this.fieldSchemas = new ArrayList<FieldSchema>();
      }
      for (FieldSchema element : elements) {
        this.fieldSchemas.add(Objects.requireNonNull(element, "fieldSchemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DatasetSchema#getFieldSchemas() fieldSchemas} list.
     * @param elements An iterable of fieldSchemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fieldSchemaList")
    public final Builder fieldSchemas(@Nullable Iterable<? extends FieldSchema> elements) {
      if (elements == null) {
        this.fieldSchemas = null;
        return this;
      }
      this.fieldSchemas = new ArrayList<FieldSchema>();
      return addAllFieldSchemas(elements);
    }

    /**
     * Adds elements to {@link DatasetSchema#getFieldSchemas() fieldSchemas} list.
     * @param elements An iterable of fieldSchemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFieldSchemas(Iterable<? extends FieldSchema> elements) {
      Objects.requireNonNull(elements, "fieldSchemas element");
      if (this.fieldSchemas == null) {
        this.fieldSchemas = new ArrayList<FieldSchema>();
      }
      for (FieldSchema element : elements) {
        this.fieldSchemas.add(Objects.requireNonNull(element, "fieldSchemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetSchema#getCustomMetadata() customMetadata} attribute.
     * @param customMetadata The value for customMetadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("customMetadata")
    public final Builder customMetadata(@Nullable DatasetCustomMetadata customMetadata) {
      this.customMetadata = customMetadata;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetSchema ImmutableDatasetSchema}.
     * @return An immutable instance of DatasetSchema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetSchema build() {
      return new ImmutableDatasetSchema(fieldSchemas == null ? null : List.copyOf(fieldSchemas), customMetadata);
    }
  }
}
