package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DatasetMetadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetMetadata.builder()}.
 */
@Generated(from = "DatasetMetadata", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDatasetMetadata
    implements DatasetMetadata {
  private final @Nullable Map<String, ColumnMetadata> columnMetadata;

  private ImmutableDatasetMetadata(
      @Nullable Map<String, ColumnMetadata> columnMetadata) {
    this.columnMetadata = columnMetadata;
  }

  /**
   * @return The value of the {@code columnMetadata} attribute
   */
  @JsonProperty("foundryColumnMetadata")
  @Override
  public @Nullable Map<String, ColumnMetadata> getColumnMetadata() {
    return columnMetadata;
  }

  /**
   * Copy the current immutable object by replacing the {@link DatasetMetadata#getColumnMetadata() columnMetadata} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the columnMetadata map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDatasetMetadata withColumnMetadata(@Nullable Map<String, ? extends ColumnMetadata> entries) {
    if (this.columnMetadata == entries) return this;
    @Nullable Map<String, ColumnMetadata> newValue = entries == null ? null : Map.copyOf(entries);
    return new ImmutableDatasetMetadata(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetMetadata
        && equalTo(0, (ImmutableDatasetMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetMetadata another) {
    return Objects.equals(columnMetadata, another.columnMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code columnMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(columnMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetMetadata{"
        + "columnMetadata=" + columnMetadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DatasetMetadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DatasetMetadata {
    @javax.annotation.Nullable Map<String, ColumnMetadata> columnMetadata = null;
    @JsonProperty("foundryColumnMetadata")
    public void setColumnMetadata(@Nullable Map<String, ColumnMetadata> columnMetadata) {
      this.columnMetadata = columnMetadata;
    }
    @Override
    public Map<String, ColumnMetadata> getColumnMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetMetadata fromJson(Json json) {
    ImmutableDatasetMetadata.Builder builder = ImmutableDatasetMetadata.builder();
    if (json.columnMetadata != null) {
      builder.putAllColumnMetadata(json.columnMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DatasetMetadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetMetadata instance
   */
  public static ImmutableDatasetMetadata copyOf(DatasetMetadata instance) {
    if (instance instanceof ImmutableDatasetMetadata) {
      return (ImmutableDatasetMetadata) instance;
    }
    return ImmutableDatasetMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetMetadata ImmutableDatasetMetadata}.
   * <pre>
   * ImmutableDatasetMetadata.builder()
   *    .columnMetadata(Map&amp;lt;String, zeenea.connector.palantir.foundry.client.model.ColumnMetadata&amp;gt; | null) // nullable {@link DatasetMetadata#getColumnMetadata() columnMetadata}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetMetadata builder
   */
  public static ImmutableDatasetMetadata.Builder builder() {
    return new ImmutableDatasetMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetMetadata ImmutableDatasetMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetMetadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, ColumnMetadata> columnMetadata = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetMetadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Map<String, ColumnMetadata> columnMetadataValue = instance.getColumnMetadata();
      if (columnMetadataValue != null) {
        putAllColumnMetadata(columnMetadataValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link DatasetMetadata#getColumnMetadata() columnMetadata} map.
     * @param key The key in the columnMetadata map
     * @param value The associated value in the columnMetadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putColumnMetadata(String key, ColumnMetadata value) {
      if (this.columnMetadata == null) {
        this.columnMetadata = new LinkedHashMap<String, ColumnMetadata>();
      }
      this.columnMetadata.put(
          Objects.requireNonNull(key, "columnMetadata key"),
          Objects.requireNonNull(value, value == null ? "columnMetadata value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link DatasetMetadata#getColumnMetadata() columnMetadata} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putColumnMetadata(Map.Entry<String, ? extends ColumnMetadata> entry) {
      if (this.columnMetadata == null) {
        this.columnMetadata = new LinkedHashMap<String, ColumnMetadata>();
      }
      String k = entry.getKey();
      ColumnMetadata v = entry.getValue();
      this.columnMetadata.put(
          Objects.requireNonNull(k, "columnMetadata key"),
          Objects.requireNonNull(v, v == null ? "columnMetadata value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DatasetMetadata#getColumnMetadata() columnMetadata} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the columnMetadata map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("foundryColumnMetadata")
    public final Builder columnMetadata(@Nullable Map<String, ? extends ColumnMetadata> entries) {
      if (entries == null) {
        this.columnMetadata = null;
        return this;
      }
      this.columnMetadata = new LinkedHashMap<String, ColumnMetadata>();
      return putAllColumnMetadata(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DatasetMetadata#getColumnMetadata() columnMetadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the columnMetadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllColumnMetadata(Map<String, ? extends ColumnMetadata> entries) {
      if (this.columnMetadata == null) {
        this.columnMetadata = new LinkedHashMap<String, ColumnMetadata>();
      }
      for (Map.Entry<String, ? extends ColumnMetadata> e : entries.entrySet()) {
        String k = e.getKey();
        ColumnMetadata v = e.getValue();
        this.columnMetadata.put(
            Objects.requireNonNull(k, "columnMetadata key"),
            Objects.requireNonNull(v, v == null ? "columnMetadata value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetMetadata ImmutableDatasetMetadata}.
     * @return An immutable instance of DatasetMetadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetMetadata build() {
      return new ImmutableDatasetMetadata(columnMetadata == null ? null : Map.copyOf(columnMetadata));
    }
  }
}
