package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DatasetCustomMetadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetCustomMetadata.builder()}.
 */
@Generated(from = "DatasetCustomMetadata", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDatasetCustomMetadata
    implements DatasetCustomMetadata {
  private final @Nullable String format;

  private ImmutableDatasetCustomMetadata(@Nullable String format) {
    this.format = format;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @JsonProperty("format")
  @Override
  public @Nullable String getFormat() {
    return format;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetCustomMetadata#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetCustomMetadata withFormat(@Nullable String value) {
    if (Objects.equals(this.format, value)) return this;
    return new ImmutableDatasetCustomMetadata(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetCustomMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetCustomMetadata
        && equalTo(0, (ImmutableDatasetCustomMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetCustomMetadata another) {
    return Objects.equals(format, another.format);
  }

  /**
   * Computes a hash code from attributes: {@code format}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(format);
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetCustomMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetCustomMetadata{"
        + "format=" + format
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DatasetCustomMetadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DatasetCustomMetadata {
    @javax.annotation.Nullable String format;
    @JsonProperty("format")
    public void setFormat(@Nullable String format) {
      this.format = format;
    }
    @Override
    public String getFormat() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetCustomMetadata fromJson(Json json) {
    ImmutableDatasetCustomMetadata.Builder builder = ImmutableDatasetCustomMetadata.builder();
    if (json.format != null) {
      builder.format(json.format);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DatasetCustomMetadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetCustomMetadata instance
   */
  public static ImmutableDatasetCustomMetadata copyOf(DatasetCustomMetadata instance) {
    if (instance instanceof ImmutableDatasetCustomMetadata) {
      return (ImmutableDatasetCustomMetadata) instance;
    }
    return ImmutableDatasetCustomMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetCustomMetadata ImmutableDatasetCustomMetadata}.
   * <pre>
   * ImmutableDatasetCustomMetadata.builder()
   *    .format(String | null) // nullable {@link DatasetCustomMetadata#getFormat() format}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetCustomMetadata builder
   */
  public static ImmutableDatasetCustomMetadata.Builder builder() {
    return new ImmutableDatasetCustomMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetCustomMetadata ImmutableDatasetCustomMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetCustomMetadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String format;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetCustomMetadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetCustomMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String formatValue = instance.getFormat();
      if (formatValue != null) {
        format(formatValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetCustomMetadata#getFormat() format} attribute.
     * @param format The value for format (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("format")
    public final Builder format(@Nullable String format) {
      this.format = format;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetCustomMetadata ImmutableDatasetCustomMetadata}.
     * @return An immutable instance of DatasetCustomMetadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetCustomMetadata build() {
      return new ImmutableDatasetCustomMetadata(format);
    }
  }
}
