package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ColumnMetadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnMetadata.builder()}.
 */
@Generated(from = "ColumnMetadata", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableColumnMetadata
    implements ColumnMetadata {
  private final @Nullable String description;

  private ImmutableColumnMetadata(@Nullable String description) {
    this.description = description;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ColumnMetadata#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumnMetadata withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableColumnMetadata(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnMetadata
        && equalTo(0, (ImmutableColumnMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumnMetadata another) {
    return Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code ColumnMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ColumnMetadata{"
        + "description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ColumnMetadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ColumnMetadata {
    @javax.annotation.Nullable String description;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableColumnMetadata fromJson(Json json) {
    ImmutableColumnMetadata.Builder builder = ImmutableColumnMetadata.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ColumnMetadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnMetadata instance
   */
  public static ImmutableColumnMetadata copyOf(ColumnMetadata instance) {
    if (instance instanceof ImmutableColumnMetadata) {
      return (ImmutableColumnMetadata) instance;
    }
    return ImmutableColumnMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumnMetadata ImmutableColumnMetadata}.
   * <pre>
   * ImmutableColumnMetadata.builder()
   *    .description(String | null) // nullable {@link ColumnMetadata#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableColumnMetadata builder
   */
  public static ImmutableColumnMetadata.Builder builder() {
    return new ImmutableColumnMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnMetadata ImmutableColumnMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnMetadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnMetadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ColumnMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ColumnMetadata#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnMetadata ImmutableColumnMetadata}.
     * @return An immutable instance of ColumnMetadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnMetadata build() {
      return new ImmutableColumnMetadata(description);
    }
  }
}
