package zeenea.connector.palantir.foundry.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link CollectionChild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCollectionChild.builder()}.
 */
@Generated(from = "CollectionChild", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCollectionChild
    implements CollectionChild {
  private final @Nullable String rid;

  private ImmutableCollectionChild(@Nullable String rid) {
    this.rid = rid;
  }

  /**
   * @return The value of the {@code rid} attribute
   */
  @JsonProperty("childRid")
  @Override
  public @Nullable String getRid() {
    return rid;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CollectionChild#getRid() rid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rid (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollectionChild withRid(@Nullable String value) {
    if (Objects.equals(this.rid, value)) return this;
    return new ImmutableCollectionChild(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollectionChild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollectionChild
        && equalTo(0, (ImmutableCollectionChild) another);
  }

  private boolean equalTo(int synthetic, ImmutableCollectionChild another) {
    return Objects.equals(rid, another.rid);
  }

  /**
   * Computes a hash code from attributes: {@code rid}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(rid);
    return h;
  }

  /**
   * Prints the immutable value {@code CollectionChild} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CollectionChild{"
        + "rid=" + rid
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CollectionChild", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CollectionChild {
    @javax.annotation.Nullable String rid;
    @JsonProperty("childRid")
    public void setRid(@Nullable String rid) {
      this.rid = rid;
    }
    @Override
    public String getRid() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCollectionChild fromJson(Json json) {
    ImmutableCollectionChild.Builder builder = ImmutableCollectionChild.builder();
    if (json.rid != null) {
      builder.rid(json.rid);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CollectionChild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CollectionChild instance
   */
  public static ImmutableCollectionChild copyOf(CollectionChild instance) {
    if (instance instanceof ImmutableCollectionChild) {
      return (ImmutableCollectionChild) instance;
    }
    return ImmutableCollectionChild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCollectionChild ImmutableCollectionChild}.
   * <pre>
   * ImmutableCollectionChild.builder()
   *    .rid(String | null) // nullable {@link CollectionChild#getRid() rid}
   *    .build();
   * </pre>
   * @return A new ImmutableCollectionChild builder
   */
  public static ImmutableCollectionChild.Builder builder() {
    return new ImmutableCollectionChild.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCollectionChild ImmutableCollectionChild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CollectionChild", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String rid;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CollectionChild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CollectionChild instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String ridValue = instance.getRid();
      if (ridValue != null) {
        rid(ridValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CollectionChild#getRid() rid} attribute.
     * @param rid The value for rid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("childRid")
    public final Builder rid(@Nullable String rid) {
      this.rid = rid;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollectionChild ImmutableCollectionChild}.
     * @return An immutable instance of CollectionChild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollectionChild build() {
      return new ImmutableCollectionChild(rid);
    }
  }
}
