package zeenea.connector.palantir.foundry;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.FsUrl;

/**
 * Immutable implementation of {@link FoundryConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFoundryConfiguration.builder()}.
 */
@Generated(from = "FoundryConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFoundryConfiguration
    implements FoundryConfiguration {
  @NotNull
  private final String connectionCode;
  private final boolean fromDataCatalog;
  private final boolean withOntology;
  @NotNull
  private final FoundryFilter foundryFilter;
  private final @Nullable FsUrl inventoryFilePath;

  private ImmutableFoundryConfiguration(
      String connectionCode,
      boolean fromDataCatalog,
      boolean withOntology,
      FoundryFilter foundryFilter,
      @Nullable FsUrl inventoryFilePath) {
    this.connectionCode = connectionCode;
    this.fromDataCatalog = fromDataCatalog;
    this.withOntology = withOntology;
    this.foundryFilter = foundryFilter;
    this.inventoryFilePath = inventoryFilePath;
  }

  /**
   * @return The value of the {@code connectionCode} attribute
   */
  @NotNull
  @Override
  public String connectionCode() {
    return connectionCode;
  }

  /**
   * @return The value of the {@code fromDataCatalog} attribute
   */
  @Override
  public boolean fromDataCatalog() {
    return fromDataCatalog;
  }

  /**
   * @return The value of the {@code withOntology} attribute
   */
  @Override
  public boolean withOntology() {
    return withOntology;
  }

  /**
   * @return The value of the {@code foundryFilter} attribute
   */
  @NotNull
  @Override
  public FoundryFilter foundryFilter() {
    return foundryFilter;
  }

  /**
   * @return The value of the {@code inventoryFilePath} attribute
   */
  @Override
  public @Nullable FsUrl inventoryFilePath() {
    return inventoryFilePath;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryConfiguration#connectionCode() connectionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryConfiguration withConnectionCode(String value) {
    String newValue = Objects.requireNonNull(value, "connectionCode");
    if (this.connectionCode.equals(newValue)) return this;
    return new ImmutableFoundryConfiguration(newValue, this.fromDataCatalog, this.withOntology, this.foundryFilter, this.inventoryFilePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryConfiguration#fromDataCatalog() fromDataCatalog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromDataCatalog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryConfiguration withFromDataCatalog(boolean value) {
    if (this.fromDataCatalog == value) return this;
    return new ImmutableFoundryConfiguration(this.connectionCode, value, this.withOntology, this.foundryFilter, this.inventoryFilePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryConfiguration#withOntology() withOntology} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for withOntology
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryConfiguration withWithOntology(boolean value) {
    if (this.withOntology == value) return this;
    return new ImmutableFoundryConfiguration(this.connectionCode, this.fromDataCatalog, value, this.foundryFilter, this.inventoryFilePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryConfiguration#foundryFilter() foundryFilter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for foundryFilter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryConfiguration withFoundryFilter(FoundryFilter value) {
    if (this.foundryFilter == value) return this;
    FoundryFilter newValue = Objects.requireNonNull(value, "foundryFilter");
    return new ImmutableFoundryConfiguration(this.connectionCode, this.fromDataCatalog, this.withOntology, newValue, this.inventoryFilePath);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FoundryConfiguration#inventoryFilePath() inventoryFilePath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inventoryFilePath (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFoundryConfiguration withInventoryFilePath(@Nullable FsUrl value) {
    if (this.inventoryFilePath == value) return this;
    return new ImmutableFoundryConfiguration(this.connectionCode, this.fromDataCatalog, this.withOntology, this.foundryFilter, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFoundryConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFoundryConfiguration
        && equalTo(0, (ImmutableFoundryConfiguration) another);
  }

  private boolean equalTo(int synthetic, ImmutableFoundryConfiguration another) {
    return connectionCode.equals(another.connectionCode)
        && fromDataCatalog == another.fromDataCatalog
        && withOntology == another.withOntology
        && foundryFilter.equals(another.foundryFilter)
        && Objects.equals(inventoryFilePath, another.inventoryFilePath);
  }

  /**
   * Computes a hash code from attributes: {@code connectionCode}, {@code fromDataCatalog}, {@code withOntology}, {@code foundryFilter}, {@code inventoryFilePath}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionCode.hashCode();
    h += (h << 5) + Boolean.hashCode(fromDataCatalog);
    h += (h << 5) + Boolean.hashCode(withOntology);
    h += (h << 5) + foundryFilter.hashCode();
    h += (h << 5) + Objects.hashCode(inventoryFilePath);
    return h;
  }

  /**
   * Prints the immutable value {@code FoundryConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FoundryConfiguration{"
        + "connectionCode=" + connectionCode
        + ", fromDataCatalog=" + fromDataCatalog
        + ", withOntology=" + withOntology
        + ", foundryFilter=" + foundryFilter
        + ", inventoryFilePath=" + inventoryFilePath
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link FoundryConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FoundryConfiguration instance
   */
  public static ImmutableFoundryConfiguration copyOf(FoundryConfiguration instance) {
    if (instance instanceof ImmutableFoundryConfiguration) {
      return (ImmutableFoundryConfiguration) instance;
    }
    return ImmutableFoundryConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFoundryConfiguration ImmutableFoundryConfiguration}.
   * <pre>
   * ImmutableFoundryConfiguration.builder()
   *    .connectionCode(String) // required {@link FoundryConfiguration#connectionCode() connectionCode}
   *    .fromDataCatalog(boolean) // required {@link FoundryConfiguration#fromDataCatalog() fromDataCatalog}
   *    .withOntology(boolean) // required {@link FoundryConfiguration#withOntology() withOntology}
   *    .foundryFilter(zeenea.connector.palantir.foundry.FoundryFilter) // required {@link FoundryConfiguration#foundryFilter() foundryFilter}
   *    .inventoryFilePath(zeenea.connector.commons.fsclient.FsUrl | null) // nullable {@link FoundryConfiguration#inventoryFilePath() inventoryFilePath}
   *    .build();
   * </pre>
   * @return A new ImmutableFoundryConfiguration builder
   */
  public static ImmutableFoundryConfiguration.Builder builder() {
    return new ImmutableFoundryConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFoundryConfiguration ImmutableFoundryConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FoundryConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CODE = 0x1L;
    private static final long INIT_BIT_FROM_DATA_CATALOG = 0x2L;
    private static final long INIT_BIT_WITH_ONTOLOGY = 0x4L;
    private static final long INIT_BIT_FOUNDRY_FILTER = 0x8L;
    private long initBits = 0xfL;

    private @javax.annotation.Nullable String connectionCode;
    private boolean fromDataCatalog;
    private boolean withOntology;
    private @javax.annotation.Nullable FoundryFilter foundryFilter;
    private @javax.annotation.Nullable FsUrl inventoryFilePath;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FoundryConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FoundryConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionCode(instance.connectionCode());
      this.fromDataCatalog(instance.fromDataCatalog());
      this.withOntology(instance.withOntology());
      this.foundryFilter(instance.foundryFilter());
      @Nullable FsUrl inventoryFilePathValue = instance.inventoryFilePath();
      if (inventoryFilePathValue != null) {
        inventoryFilePath(inventoryFilePathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryConfiguration#connectionCode() connectionCode} attribute.
     * @param connectionCode The value for connectionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionCode(String connectionCode) {
      this.connectionCode = Objects.requireNonNull(connectionCode, "connectionCode");
      initBits &= ~INIT_BIT_CONNECTION_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryConfiguration#fromDataCatalog() fromDataCatalog} attribute.
     * @param fromDataCatalog The value for fromDataCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fromDataCatalog(boolean fromDataCatalog) {
      this.fromDataCatalog = fromDataCatalog;
      initBits &= ~INIT_BIT_FROM_DATA_CATALOG;
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryConfiguration#withOntology() withOntology} attribute.
     * @param withOntology The value for withOntology 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOntology(boolean withOntology) {
      this.withOntology = withOntology;
      initBits &= ~INIT_BIT_WITH_ONTOLOGY;
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryConfiguration#foundryFilter() foundryFilter} attribute.
     * @param foundryFilter The value for foundryFilter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder foundryFilter(FoundryFilter foundryFilter) {
      this.foundryFilter = Objects.requireNonNull(foundryFilter, "foundryFilter");
      initBits &= ~INIT_BIT_FOUNDRY_FILTER;
      return this;
    }

    /**
     * Initializes the value for the {@link FoundryConfiguration#inventoryFilePath() inventoryFilePath} attribute.
     * @param inventoryFilePath The value for inventoryFilePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inventoryFilePath(@Nullable FsUrl inventoryFilePath) {
      this.inventoryFilePath = inventoryFilePath;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFoundryConfiguration ImmutableFoundryConfiguration}.
     * @return An immutable instance of FoundryConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFoundryConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFoundryConfiguration(connectionCode, fromDataCatalog, withOntology, foundryFilter, inventoryFilePath);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CODE) != 0) attributes.add("connectionCode");
      if ((initBits & INIT_BIT_FROM_DATA_CATALOG) != 0) attributes.add("fromDataCatalog");
      if ((initBits & INIT_BIT_WITH_ONTOLOGY) != 0) attributes.add("withOntology");
      if ((initBits & INIT_BIT_FOUNDRY_FILTER) != 0) attributes.add("foundryFilter");
      return "Cannot build FoundryConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
