/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.net.URI;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.configuration.AwsConfiguration;
import zeenea.connector.commons.fsclient.ImmutableS3Config;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

@ImmutablePojo
public abstract class S3Config {
    private static final SimpleLogger log = SimpleLogger.of(S3Config.class);

    public abstract Region region();

    @Nullable
    public abstract AwsCredentialsProvider credentialsProvider();

    @Nullable
    public abstract URI awsEndpoint();

    @Nullable
    public abstract Proxy proxy();

    public static S3Config parse(TracingContext ctx, PropertyValueMap configuration) {
        log.entry("fs_client_s3_config_parse").context(ctx).debug();
        ImmutableS3Config.Builder builder = ImmutableS3Config.builder();
        builder.region(S3Config.awsRegion(ctx, configuration));
        S3Config.awsCredentialProvider(configuration).ifPresent(builder::credentialsProvider);
        S3Config.awsEndpoint(ctx, configuration).ifPresent(builder::awsEndpoint);
        builder.proxy(Proxy.builder().configuration(configuration).build());
        return builder.build();
    }

    public static S3Config parse(TracingContext ctx, ConnectionConfiguration configuration) {
        log.entry("fs_client_s3_config_parse").context(ctx).debug();
        ImmutableS3Config.Builder builder = ImmutableS3Config.builder();
        builder.region(S3Config.awsRegion(ctx, configuration));
        S3Config.awsCredentialProvider(configuration).ifPresent(builder::credentialsProvider);
        S3Config.awsEndpoint(ctx, configuration).ifPresent(builder::awsEndpoint);
        builder.proxy(Proxy.builder().configuration(configuration).build());
        return builder.build();
    }

    private static Region awsRegion(TracingContext ctx, PropertyValueMap configuration) {
        try {
            return configuration.get((SourceStringProperty)AwsConfiguration.AWS_REGION).map(Region::of).orElseGet(() -> DefaultAwsRegionProviderChain.builder().build().getRegion());
        }
        catch (RuntimeException e) {
            throw (ConnectorConfigurationException)log.entry("fs_client_s3_config_aws_region_failure").context(ctx).exception((Throwable)e, (m, ex) -> new ConnectorConfigurationException((SourceProperty)AwsConfiguration.AWS_REGION, m, (Throwable)ex));
        }
    }

    private static Region awsRegion(TracingContext ctx, ConnectionConfiguration configuration) {
        try {
            return configuration.getStringOptional(AwsConfiguration.AWS_REGION.key().name()).map(Region::of).orElseGet(() -> DefaultAwsRegionProviderChain.builder().build().getRegion());
        }
        catch (RuntimeException e) {
            throw (ConnectorConfigurationException)log.entry("fs_client_s3_config_aws_region_failure").context(ctx).exception((Throwable)e, (m, ex) -> new ConnectorConfigurationException((SourceProperty)AwsConfiguration.AWS_REGION, m, (Throwable)ex));
        }
    }

    private static Optional<AwsCredentialsProvider> awsCredentialProvider(PropertyValueMap configuration) {
        return configuration.get((SourceStringProperty)AwsConfiguration.AWS_ACCESS_KEY).map(accessKey -> {
            String secretKey = configuration.getRequired((SourceStringProperty)AwsConfiguration.AWS_SECRET_KEY);
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }).or(() -> configuration.get((SourceStringProperty)AwsConfiguration.AWS_PROFILE).map(ProfileCredentialsProvider::create));
    }

    private static Optional<AwsCredentialsProvider> awsCredentialProvider(ConnectionConfiguration configuration) {
        return configuration.getStringOptional(AwsConfiguration.AWS_ACCESS_KEY.key().name()).map(accessKey -> {
            String secretKey = configuration.getString(AwsConfiguration.AWS_SECRET_KEY.key().name());
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }).or(() -> configuration.getStringOptional(AwsConfiguration.AWS_PROFILE.key().name()).map(ProfileCredentialsProvider::create));
    }

    private static Optional<URI> awsEndpoint(TracingContext ctx, PropertyValueMap configuration) {
        try {
            return configuration.get((SourceStringProperty)AwsConfiguration.AWS_URL).map(URI::create);
        }
        catch (IllegalArgumentException e) {
            throw (ConnectorConfigurationException)log.entry("fs_client_s3_config_aws_url_invalid").context(ctx).exception((Throwable)e, (m, ex) -> new ConnectorConfigurationException((SourceProperty)AwsConfiguration.AWS_URL, m, (Throwable)ex));
        }
    }

    private static Optional<URI> awsEndpoint(TracingContext ctx, ConnectionConfiguration configuration) {
        try {
            return configuration.getStringOptional(AwsConfiguration.AWS_URL.key().name()).map(URI::create);
        }
        catch (IllegalArgumentException e) {
            throw (ConnectorConfigurationException)log.entry("fs_client_s3_config_aws_url_invalid").context(ctx).exception((Throwable)e, (m, ex) -> new ConnectorConfigurationException((SourceProperty)AwsConfiguration.AWS_URL, m, (Throwable)ex));
        }
    }
}

