/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import zeenea.connector.commons.fsclient.S3Config;
import zeenea.connector.commons.proxy.Proxy;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3Config", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableS3Config
extends S3Config {
    private final Region region;
    @Nullable
    private final AwsCredentialsProvider credentialsProvider;
    @Nullable
    private final URI awsEndpoint;
    @Nullable
    private final Proxy proxy;

    private ImmutableS3Config(Region region, @Nullable AwsCredentialsProvider credentialsProvider, @Nullable URI awsEndpoint, @Nullable Proxy proxy) {
        this.region = region;
        this.credentialsProvider = credentialsProvider;
        this.awsEndpoint = awsEndpoint;
        this.proxy = proxy;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    @Nullable
    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    @Nullable
    public URI awsEndpoint() {
        return this.awsEndpoint;
    }

    @Override
    @Nullable
    public Proxy proxy() {
        return this.proxy;
    }

    public final ImmutableS3Config withRegion(Region value) {
        if (this.region == value) {
            return this;
        }
        Region newValue = Objects.requireNonNull(value, "region");
        return new ImmutableS3Config(newValue, this.credentialsProvider, this.awsEndpoint, this.proxy);
    }

    public final ImmutableS3Config withCredentialsProvider(@Nullable AwsCredentialsProvider value) {
        if (this.credentialsProvider == value) {
            return this;
        }
        return new ImmutableS3Config(this.region, value, this.awsEndpoint, this.proxy);
    }

    public final ImmutableS3Config withAwsEndpoint(@Nullable URI value) {
        if (this.awsEndpoint == value) {
            return this;
        }
        return new ImmutableS3Config(this.region, this.credentialsProvider, value, this.proxy);
    }

    public final ImmutableS3Config withProxy(@Nullable Proxy value) {
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableS3Config(this.region, this.credentialsProvider, this.awsEndpoint, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3Config && this.equalTo(0, (ImmutableS3Config)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3Config another) {
        return this.region.equals(another.region) && Objects.equals(this.credentialsProvider, another.credentialsProvider) && Objects.equals(this.awsEndpoint, another.awsEndpoint) && Objects.equals(this.proxy, another.proxy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + Objects.hashCode(this.credentialsProvider);
        h += (h << 5) + Objects.hashCode(this.awsEndpoint);
        h += (h << 5) + Objects.hashCode(this.proxy);
        return h;
    }

    public String toString() {
        return "S3Config{region=" + String.valueOf(this.region) + ", credentialsProvider=" + String.valueOf(this.credentialsProvider) + ", awsEndpoint=" + String.valueOf(this.awsEndpoint) + ", proxy=" + String.valueOf(this.proxy) + "}";
    }

    public static ImmutableS3Config copyOf(S3Config instance) {
        if (instance instanceof ImmutableS3Config) {
            return (ImmutableS3Config)instance;
        }
        return ImmutableS3Config.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REGION = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private Region region;
        @javax.annotation.Nullable
        private AwsCredentialsProvider credentialsProvider;
        @javax.annotation.Nullable
        private URI awsEndpoint;
        @javax.annotation.Nullable
        private Proxy proxy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3Config instance) {
            Proxy proxyValue;
            URI awsEndpointValue;
            Objects.requireNonNull(instance, "instance");
            this.region(instance.region());
            @Nullable AwsCredentialsProvider credentialsProviderValue = instance.credentialsProvider();
            if (credentialsProviderValue != null) {
                this.credentialsProvider(credentialsProviderValue);
            }
            if ((awsEndpointValue = instance.awsEndpoint()) != null) {
                this.awsEndpoint(awsEndpointValue);
            }
            if ((proxyValue = instance.proxy()) != null) {
                this.proxy(proxyValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(Region region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentialsProvider(@Nullable AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder awsEndpoint(@Nullable URI awsEndpoint) {
            this.awsEndpoint = awsEndpoint;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public ImmutableS3Config build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3Config(this.region, this.credentialsProvider, this.awsEndpoint, this.proxy);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("region");
            }
            return "Cannot build S3Config, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

