/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.Adls2Config;
import zeenea.connector.commons.fsclient.CompositeConfig;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.GsConfig;
import zeenea.connector.commons.fsclient.S3Config;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CompositeConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCompositeConfig
extends CompositeConfig {
    private final EnumSet<FsName> enabledFs;
    @Nullable
    private final S3Config s3Config;
    @Nullable
    private final GsConfig gsConfig;
    @Nullable
    private final Adls2Config adls2Config;

    private ImmutableCompositeConfig(EnumSet<FsName> enabledFs, @Nullable S3Config s3Config, @Nullable GsConfig gsConfig, @Nullable Adls2Config adls2Config) {
        this.enabledFs = enabledFs;
        this.s3Config = s3Config;
        this.gsConfig = gsConfig;
        this.adls2Config = adls2Config;
    }

    @Override
    public EnumSet<FsName> enabledFs() {
        return this.enabledFs;
    }

    @Override
    @Nullable
    public S3Config s3Config() {
        return this.s3Config;
    }

    @Override
    @Nullable
    public GsConfig gsConfig() {
        return this.gsConfig;
    }

    @Override
    @Nullable
    public Adls2Config adls2Config() {
        return this.adls2Config;
    }

    public final ImmutableCompositeConfig withEnabledFs(EnumSet<FsName> value) {
        if (this.enabledFs == value) {
            return this;
        }
        EnumSet<FsName> newValue = Objects.requireNonNull(value, "enabledFs");
        return new ImmutableCompositeConfig(newValue, this.s3Config, this.gsConfig, this.adls2Config);
    }

    public final ImmutableCompositeConfig withS3Config(@Nullable S3Config value) {
        if (this.s3Config == value) {
            return this;
        }
        return new ImmutableCompositeConfig(this.enabledFs, value, this.gsConfig, this.adls2Config);
    }

    public final ImmutableCompositeConfig withGsConfig(@Nullable GsConfig value) {
        if (this.gsConfig == value) {
            return this;
        }
        return new ImmutableCompositeConfig(this.enabledFs, this.s3Config, value, this.adls2Config);
    }

    public final ImmutableCompositeConfig withAdls2Config(@Nullable Adls2Config value) {
        if (this.adls2Config == value) {
            return this;
        }
        return new ImmutableCompositeConfig(this.enabledFs, this.s3Config, this.gsConfig, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompositeConfig && this.equalTo(0, (ImmutableCompositeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCompositeConfig another) {
        return this.enabledFs.equals(another.enabledFs) && Objects.equals(this.s3Config, another.s3Config) && Objects.equals(this.gsConfig, another.gsConfig) && Objects.equals(this.adls2Config, another.adls2Config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.enabledFs.hashCode();
        h += (h << 5) + Objects.hashCode(this.s3Config);
        h += (h << 5) + Objects.hashCode(this.gsConfig);
        h += (h << 5) + Objects.hashCode(this.adls2Config);
        return h;
    }

    public String toString() {
        return "CompositeConfig{enabledFs=" + String.valueOf(this.enabledFs) + ", s3Config=" + String.valueOf(this.s3Config) + ", gsConfig=" + String.valueOf(this.gsConfig) + ", adls2Config=" + String.valueOf(this.adls2Config) + "}";
    }

    public static ImmutableCompositeConfig copyOf(CompositeConfig instance) {
        if (instance instanceof ImmutableCompositeConfig) {
            return (ImmutableCompositeConfig)instance;
        }
        return ImmutableCompositeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CompositeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENABLED_FS = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private EnumSet<FsName> enabledFs;
        @javax.annotation.Nullable
        private S3Config s3Config;
        @javax.annotation.Nullable
        private GsConfig gsConfig;
        @javax.annotation.Nullable
        private Adls2Config adls2Config;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompositeConfig instance) {
            Adls2Config adls2ConfigValue;
            GsConfig gsConfigValue;
            Objects.requireNonNull(instance, "instance");
            this.enabledFs(instance.enabledFs());
            @Nullable S3Config s3ConfigValue = instance.s3Config();
            if (s3ConfigValue != null) {
                this.s3Config(s3ConfigValue);
            }
            if ((gsConfigValue = instance.gsConfig()) != null) {
                this.gsConfig(gsConfigValue);
            }
            if ((adls2ConfigValue = instance.adls2Config()) != null) {
                this.adls2Config(adls2ConfigValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enabledFs(EnumSet<FsName> enabledFs) {
            this.enabledFs = Objects.requireNonNull(enabledFs, "enabledFs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder s3Config(@Nullable S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gsConfig(@Nullable GsConfig gsConfig) {
            this.gsConfig = gsConfig;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adls2Config(@Nullable Adls2Config adls2Config) {
            this.adls2Config = adls2Config;
            return this;
        }

        public ImmutableCompositeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompositeConfig(this.enabledFs, this.s3Config, this.gsConfig, this.adls2Config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabledFs");
            }
            return "Cannot build CompositeConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

