/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.util.EnumSet;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.commons.fsclient.Adls2Config;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.GsConfig;
import zeenea.connector.commons.fsclient.ImmutableCompositeConfig;
import zeenea.connector.commons.fsclient.S3Config;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.jdk.PropertyValueMap;

@ImmutablePojo
public abstract class CompositeConfig {
    private static final SimpleLogger log = SimpleLogger.of(CompositeConfig.class);

    public abstract EnumSet<FsName> enabledFs();

    @Nullable
    public abstract S3Config s3Config();

    @Nullable
    public abstract GsConfig gsConfig();

    @Nullable
    public abstract Adls2Config adls2Config();

    public static CompositeConfig parse(TracingContext ctx, PropertyValueMap configuration, EnumSet<FsName> enabledFs) {
        log.entry("fs_client_composite_config_parse").context(ctx).with("enabled_fs", enabledFs).debug();
        ImmutableCompositeConfig.Builder builder = ImmutableCompositeConfig.builder();
        builder.enabledFs(enabledFs);
        if (enabledFs.contains((Object)FsName.S3)) {
            builder.s3Config(S3Config.parse(ctx, configuration));
        }
        if (enabledFs.contains((Object)FsName.GS)) {
            builder.gsConfig(GsConfig.parse(ctx, configuration));
        }
        if (enabledFs.contains((Object)FsName.ADLS2)) {
            builder.adls2Config(Adls2Config.parse(ctx, configuration));
        }
        return builder.build();
    }

    public static CompositeConfig parse(TracingContext ctx, ConnectionConfiguration configuration, EnumSet<FsName> enabledFs) {
        log.entry("fs_client_composite_config_parse").context(ctx).with("enabled_fs", enabledFs).debug();
        ImmutableCompositeConfig.Builder builder = ImmutableCompositeConfig.builder();
        builder.enabledFs(enabledFs);
        if (enabledFs.contains((Object)FsName.S3)) {
            builder.s3Config(S3Config.parse(ctx, configuration));
        }
        if (enabledFs.contains((Object)FsName.GS)) {
            builder.gsConfig(GsConfig.parse(ctx, configuration));
        }
        if (enabledFs.contains((Object)FsName.ADLS2)) {
            builder.adls2Config(Adls2Config.parse(ctx, configuration));
        }
        return builder.build();
    }
}

