/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class AcceptedType {
    public static final AcceptedType JSON = AcceptedType.of("application", "json");
    public static final AcceptedType APPLICATION_XML = AcceptedType.of("application", "xml");
    public static final AcceptedType TEXT_XML = AcceptedType.of("text", "xml");
    public static final AcceptedType ANY = AcceptedType.of("*", "*");
    private final String type;
    private final String subType;
    @Nullable
    private final Float q;

    private AcceptedType(String type, String subType, @Nullable Float q) {
        this.type = type;
        this.subType = subType;
        this.q = q;
    }

    public static AcceptedType of(String type, String subType, @Nullable Float q) {
        return new AcceptedType(type, subType, q);
    }

    public static AcceptedType of(String type, String subType) {
        return AcceptedType.of(type, subType, null);
    }

    public String principalType() {
        return this.type;
    }

    public String subType() {
        return this.subType;
    }

    public Float q() {
        return this.q;
    }

    public AcceptedType withQ(@Nullable Float q) {
        return AcceptedType.of(this.type, this.subType, q);
    }

    public String mimeType() {
        return this.type + "/" + this.subType;
    }

    public String toString() {
        if (this.q == null) {
            return this.mimeType();
        }
        return String.format("%s/%s;%.3f", this.type, this.subType, this.q);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptedType that = (AcceptedType)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.subType, that.subType) && Objects.equals(this.q, that.q);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subType, this.q);
    }
}

