package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Schema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchema.builder()}.
 */
@Generated(from = "Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSchema implements Schema {
  private final @Nullable Map<String, Property> properties;
  private final @Nullable String type;
  private final @Nullable Item items;
  private final @Nullable String reference;

  private ImmutableSchema(
      @Nullable Map<String, Property> properties,
      @Nullable String type,
      @Nullable Item items,
      @Nullable String reference) {
    this.properties = properties;
    this.type = type;
    this.items = items;
    this.reference = reference;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public @Nullable Map<String, Property> getProperties() {
    return properties;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @JsonProperty("items")
  @Override
  public @Nullable Item getItems() {
    return items;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @JsonProperty("$ref")
  @Override
  public @Nullable String getReference() {
    return reference;
  }

  /**
   * Copy the current immutable object by replacing the {@link Schema#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchema withProperties(@Nullable Map<String, ? extends Property> entries) {
    if (this.properties == entries) return this;
    @Nullable Map<String, Property> newValue = entries == null ? null : Map.copyOf(entries);
    return new ImmutableSchema(newValue, this.type, this.items, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableSchema(this.properties, value, this.items, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getItems() items} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for items (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withItems(@Nullable Item value) {
    if (this.items == value) return this;
    return new ImmutableSchema(this.properties, this.type, value, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getReference() reference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withReference(@Nullable String value) {
    if (Objects.equals(this.reference, value)) return this;
    return new ImmutableSchema(this.properties, this.type, this.items, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchema
        && equalTo(0, (ImmutableSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableSchema another) {
    return Objects.equals(properties, another.properties)
        && Objects.equals(type, another.type)
        && Objects.equals(items, another.items)
        && Objects.equals(reference, another.reference);
  }

  /**
   * Computes a hash code from attributes: {@code properties}, {@code type}, {@code items}, {@code reference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(properties);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(items);
    h += (h << 5) + Objects.hashCode(reference);
    return h;
  }

  /**
   * Prints the immutable value {@code Schema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schema{"
        + "properties=" + properties
        + ", type=" + type
        + ", items=" + items
        + ", reference=" + reference
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Schema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Schema {
    @javax.annotation.Nullable Map<String, Property> properties = null;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable Item items;
    @javax.annotation.Nullable String reference;
    @JsonProperty("properties")
    public void setProperties(@Nullable Map<String, Property> properties) {
      this.properties = properties;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("items")
    public void setItems(@Nullable Item items) {
      this.items = items;
    }
    @JsonProperty("$ref")
    public void setReference(@Nullable String reference) {
      this.reference = reference;
    }
    @Override
    public Map<String, Property> getProperties() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Item getItems() { throw new UnsupportedOperationException(); }
    @Override
    public String getReference() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSchema fromJson(Json json) {
    ImmutableSchema.Builder builder = ImmutableSchema.builder();
    if (json.properties != null) {
      builder.putAllProperties(json.properties);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.items != null) {
      builder.items(json.items);
    }
    if (json.reference != null) {
      builder.reference(json.reference);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Schema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schema instance
   */
  public static ImmutableSchema copyOf(Schema instance) {
    if (instance instanceof ImmutableSchema) {
      return (ImmutableSchema) instance;
    }
    return ImmutableSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchema ImmutableSchema}.
   * <pre>
   * ImmutableSchema.builder()
   *    .properties(Map&amp;lt;String, zeenea.connector.openapi.client.model.Property&amp;gt; | null) // nullable {@link Schema#getProperties() properties}
   *    .type(String | null) // nullable {@link Schema#getType() type}
   *    .items(zeenea.connector.openapi.client.model.Item | null) // nullable {@link Schema#getItems() items}
   *    .reference(String | null) // nullable {@link Schema#getReference() reference}
   *    .build();
   * </pre>
   * @return A new ImmutableSchema builder
   */
  public static ImmutableSchema.Builder builder() {
    return new ImmutableSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchema ImmutableSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, Property> properties = null;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable Item items;
    private @javax.annotation.Nullable String reference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schema instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Map<String, Property> propertiesValue = instance.getProperties();
      if (propertiesValue != null) {
        putAllProperties(propertiesValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable Item itemsValue = instance.getItems();
      if (itemsValue != null) {
        items(itemsValue);
      }
      @Nullable String referenceValue = instance.getReference();
      if (referenceValue != null) {
        reference(referenceValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Schema#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProperties(String key, Property value) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      this.properties.put(
          Objects.requireNonNull(key, "properties key"),
          Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Schema#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProperties(Map.Entry<String, ? extends Property> entry) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      String k = entry.getKey();
      Property v = entry.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Schema#getProperties() properties} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("properties")
    public final Builder properties(@Nullable Map<String, ? extends Property> entries) {
      if (entries == null) {
        this.properties = null;
        return this;
      }
      this.properties = new LinkedHashMap<String, Property>();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Schema#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProperties(Map<String, ? extends Property> entries) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      for (Map.Entry<String, ? extends Property> e : entries.entrySet()) {
        String k = e.getKey();
        Property v = e.getValue();
        this.properties.put(
            Objects.requireNonNull(k, "properties key"),
            Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getItems() items} attribute.
     * @param items The value for items (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("items")
    public final Builder items(@Nullable Item items) {
      this.items = items;
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getReference() reference} attribute.
     * @param reference The value for reference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("$ref")
    public final Builder reference(@Nullable String reference) {
      this.reference = reference;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchema ImmutableSchema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchema build() {
      return new ImmutableSchema(properties == null ? null : Map.copyOf(properties), type, items, reference);
    }
  }
}
