package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Response}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResponse.builder()}.
 */
@Generated(from = "Response", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableResponse implements Response {
  private final @Nullable String description;
  private final @Nullable Content content;

  private ImmutableResponse(
      @Nullable String description,
      @Nullable Content content) {
    this.description = description;
    this.content = content;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public @Nullable Content getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Response#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponse withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableResponse(value, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Response#getContent() content} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponse withContent(@Nullable Content value) {
    if (this.content == value) return this;
    return new ImmutableResponse(this.description, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResponse
        && equalTo(0, (ImmutableResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableResponse another) {
    return Objects.equals(description, another.description)
        && Objects.equals(content, another.content);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(content);
    return h;
  }

  /**
   * Prints the immutable value {@code Response} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Response{"
        + "description=" + description
        + ", content=" + content
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Response", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Response {
    @Nullable String description;
    @Nullable Content content;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("content")
    public void setContent(@Nullable Content content) {
      this.content = content;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Content getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableResponse fromJson(Json json) {
    ImmutableResponse.Builder builder = ImmutableResponse.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Response} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Response instance
   */
  public static ImmutableResponse copyOf(Response instance) {
    if (instance instanceof ImmutableResponse) {
      return (ImmutableResponse) instance;
    }
    return ImmutableResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResponse ImmutableResponse}.
   * <pre>
   * ImmutableResponse.builder()
   *    .description(String | null) // nullable {@link Response#getDescription() description}
   *    .content(zeenea.connector.openapi.client.model.Content | null) // nullable {@link Response#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutableResponse builder
   */
  public static ImmutableResponse.Builder builder() {
    return new ImmutableResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResponse ImmutableResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Response", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String description;
    private @Nullable Content content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Response} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Response instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable Content contentValue = instance.getContent();
      if (contentValue != null) {
        content(contentValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Response#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Response#getContent() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("content")
    public final Builder content(@Nullable Content content) {
      this.content = content;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResponse ImmutableResponse}.
     * @return An immutable instance of Response
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResponse build() {
      return new ImmutableResponse(description, content);
    }
  }
}
