package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Property}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProperty.builder()}.
 */
@Generated(from = "Property", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProperty implements Property {
  private final @Nullable Item items;
  private final @Nullable List<AllOf> allOf;
  private final @Nullable String reference;
  private final @Nullable String type;
  private final @Nullable String format;
  private final @Nullable String nullable;
  private final @Nullable String description;

  private ImmutableProperty(
      @Nullable Item items,
      @Nullable List<AllOf> allOf,
      @Nullable String reference,
      @Nullable String type,
      @Nullable String format,
      @Nullable String nullable,
      @Nullable String description) {
    this.items = items;
    this.allOf = allOf;
    this.reference = reference;
    this.type = type;
    this.format = format;
    this.nullable = nullable;
    this.description = description;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @JsonProperty("items")
  @Override
  public @Nullable Item getItems() {
    return items;
  }

  /**
   * @return The value of the {@code allOf} attribute
   */
  @JsonProperty("allOf")
  @Override
  public @Nullable List<AllOf> getAllOf() {
    return allOf;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @JsonProperty("$ref")
  @Override
  public @Nullable String getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code format} attribute
   */
  @JsonProperty("format")
  @Override
  public @Nullable String getFormat() {
    return format;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public @Nullable String getNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getItems() items} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for items (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withItems(@Nullable Item value) {
    if (this.items == value) return this;
    return new ImmutableProperty(value, this.allOf, this.reference, this.type, this.format, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Property#getAllOf() allOf}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProperty withAllOf(@Nullable AllOf... elements) {
    if (elements == null) {
      return new ImmutableProperty(this.items, null, this.reference, this.type, this.format, this.nullable, this.description);
    }
    List<AllOf> newValue = List.of(elements);
    return new ImmutableProperty(this.items, newValue, this.reference, this.type, this.format, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Property#getAllOf() allOf}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of allOf elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProperty withAllOf(@Nullable Iterable<? extends AllOf> elements) {
    if (this.allOf == elements) return this;
    @Nullable List<AllOf> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends AllOf>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableProperty(this.items, newValue, this.reference, this.type, this.format, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getReference() reference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withReference(@Nullable String value) {
    if (Objects.equals(this.reference, value)) return this;
    return new ImmutableProperty(this.items, this.allOf, value, this.type, this.format, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableProperty(this.items, this.allOf, this.reference, value, this.format, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getFormat() format} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for format (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withFormat(@Nullable String value) {
    if (Objects.equals(this.format, value)) return this;
    return new ImmutableProperty(this.items, this.allOf, this.reference, this.type, value, this.nullable, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getNullable() nullable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withNullable(@Nullable String value) {
    if (Objects.equals(this.nullable, value)) return this;
    return new ImmutableProperty(this.items, this.allOf, this.reference, this.type, this.format, value, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Property#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProperty withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableProperty(this.items, this.allOf, this.reference, this.type, this.format, this.nullable, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProperty} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProperty
        && equalTo(0, (ImmutableProperty) another);
  }

  private boolean equalTo(int synthetic, ImmutableProperty another) {
    return Objects.equals(items, another.items)
        && Objects.equals(allOf, another.allOf)
        && Objects.equals(reference, another.reference)
        && Objects.equals(type, another.type)
        && Objects.equals(format, another.format)
        && Objects.equals(nullable, another.nullable)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code items}, {@code allOf}, {@code reference}, {@code type}, {@code format}, {@code nullable}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(items);
    h += (h << 5) + Objects.hashCode(allOf);
    h += (h << 5) + Objects.hashCode(reference);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(format);
    h += (h << 5) + Objects.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code Property} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Property{"
        + "items=" + items
        + ", allOf=" + allOf
        + ", reference=" + reference
        + ", type=" + type
        + ", format=" + format
        + ", nullable=" + nullable
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Property", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Property {
    @javax.annotation.Nullable Item items;
    @javax.annotation.Nullable List<AllOf> allOf = null;
    @javax.annotation.Nullable String reference;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String format;
    @javax.annotation.Nullable String nullable;
    @javax.annotation.Nullable String description;
    @JsonProperty("items")
    public void setItems(@Nullable Item items) {
      this.items = items;
    }
    @JsonProperty("allOf")
    public void setAllOf(@Nullable List<AllOf> allOf) {
      this.allOf = allOf;
    }
    @JsonProperty("$ref")
    public void setReference(@Nullable String reference) {
      this.reference = reference;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("format")
    public void setFormat(@Nullable String format) {
      this.format = format;
    }
    @JsonProperty("nullable")
    public void setNullable(@Nullable String nullable) {
      this.nullable = nullable;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public Item getItems() { throw new UnsupportedOperationException(); }
    @Override
    public List<AllOf> getAllOf() { throw new UnsupportedOperationException(); }
    @Override
    public String getReference() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormat() { throw new UnsupportedOperationException(); }
    @Override
    public String getNullable() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProperty fromJson(Json json) {
    ImmutableProperty.Builder builder = ImmutableProperty.builder();
    if (json.items != null) {
      builder.items(json.items);
    }
    if (json.allOf != null) {
      builder.addAllAllOf(json.allOf);
    }
    if (json.reference != null) {
      builder.reference(json.reference);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.format != null) {
      builder.format(json.format);
    }
    if (json.nullable != null) {
      builder.nullable(json.nullable);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Property} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Property instance
   */
  public static ImmutableProperty copyOf(Property instance) {
    if (instance instanceof ImmutableProperty) {
      return (ImmutableProperty) instance;
    }
    return ImmutableProperty.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProperty ImmutableProperty}.
   * <pre>
   * ImmutableProperty.builder()
   *    .items(zeenea.connector.openapi.client.model.Item | null) // nullable {@link Property#getItems() items}
   *    .allOf(List&amp;lt;zeenea.connector.openapi.client.model.AllOf&amp;gt; | null) // nullable {@link Property#getAllOf() allOf}
   *    .reference(String | null) // nullable {@link Property#getReference() reference}
   *    .type(String | null) // nullable {@link Property#getType() type}
   *    .format(String | null) // nullable {@link Property#getFormat() format}
   *    .nullable(String | null) // nullable {@link Property#getNullable() nullable}
   *    .description(String | null) // nullable {@link Property#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableProperty builder
   */
  public static ImmutableProperty.Builder builder() {
    return new ImmutableProperty.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProperty ImmutableProperty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Property", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Item items;
    private List<AllOf> allOf = null;
    private @javax.annotation.Nullable String reference;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String format;
    private @javax.annotation.Nullable String nullable;
    private @javax.annotation.Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Property} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Property instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Item itemsValue = instance.getItems();
      if (itemsValue != null) {
        items(itemsValue);
      }
      @Nullable List<AllOf> allOfValue = instance.getAllOf();
      if (allOfValue != null) {
        addAllAllOf(allOfValue);
      }
      @Nullable String referenceValue = instance.getReference();
      if (referenceValue != null) {
        reference(referenceValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String formatValue = instance.getFormat();
      if (formatValue != null) {
        format(formatValue);
      }
      @Nullable String nullableValue = instance.getNullable();
      if (nullableValue != null) {
        nullable(nullableValue);
      }
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getItems() items} attribute.
     * @param items The value for items (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("items")
    public final Builder items(@Nullable Item items) {
      this.items = items;
      return this;
    }

    /**
     * Adds one element to {@link Property#getAllOf() allOf} list.
     * @param element A allOf element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOf(AllOf element) {
      if (this.allOf == null) {
        this.allOf = new ArrayList<AllOf>();
      }
      this.allOf.add(Objects.requireNonNull(element, "allOf element"));
      return this;
    }

    /**
     * Adds elements to {@link Property#getAllOf() allOf} list.
     * @param elements An array of allOf elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOf(AllOf... elements) {
      if (this.allOf == null) {
        this.allOf = new ArrayList<AllOf>();
      }
      for (AllOf element : elements) {
        this.allOf.add(Objects.requireNonNull(element, "allOf element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Property#getAllOf() allOf} list.
     * @param elements An iterable of allOf elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allOf")
    public final Builder allOf(@Nullable Iterable<? extends AllOf> elements) {
      if (elements == null) {
        this.allOf = null;
        return this;
      }
      this.allOf = new ArrayList<AllOf>();
      return addAllAllOf(elements);
    }

    /**
     * Adds elements to {@link Property#getAllOf() allOf} list.
     * @param elements An iterable of allOf elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllOf(Iterable<? extends AllOf> elements) {
      Objects.requireNonNull(elements, "allOf element");
      if (this.allOf == null) {
        this.allOf = new ArrayList<AllOf>();
      }
      for (AllOf element : elements) {
        this.allOf.add(Objects.requireNonNull(element, "allOf element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getReference() reference} attribute.
     * @param reference The value for reference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("$ref")
    public final Builder reference(@Nullable String reference) {
      this.reference = reference;
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getFormat() format} attribute.
     * @param format The value for format (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("format")
    public final Builder format(@Nullable String format) {
      this.format = format;
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getNullable() nullable} attribute.
     * @param nullable The value for nullable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    public final Builder nullable(@Nullable String nullable) {
      this.nullable = nullable;
      return this;
    }

    /**
     * Initializes the value for the {@link Property#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProperty ImmutableProperty}.
     * @return An immutable instance of Property
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProperty build() {
      return new ImmutableProperty(
          items,
          allOf == null ? null : List.copyOf(allOf),
          reference,
          type,
          format,
          nullable,
          description);
    }
  }
}
