package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Path}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePath.builder()}.
 */
@Generated(from = "Path", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePath implements Path {
  private final @Nullable Endpoint endpoint;

  private ImmutablePath(@Nullable Endpoint endpoint) {
    this.endpoint = endpoint;
  }

  /**
   * @return The value of the {@code endpoint} attribute
   */
  @JsonProperty("get")
  @Override
  public @Nullable Endpoint getEndpoint() {
    return endpoint;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Path#getEndpoint() endpoint} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endpoint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePath withEndpoint(@Nullable Endpoint value) {
    if (this.endpoint == value) return this;
    return new ImmutablePath(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePath} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePath
        && equalTo(0, (ImmutablePath) another);
  }

  private boolean equalTo(int synthetic, ImmutablePath another) {
    return Objects.equals(endpoint, another.endpoint);
  }

  /**
   * Computes a hash code from attributes: {@code endpoint}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(endpoint);
    return h;
  }

  /**
   * Prints the immutable value {@code Path} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Path{"
        + "endpoint=" + endpoint
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Path", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Path {
    @Nullable Endpoint endpoint;
    @JsonProperty("get")
    public void setEndpoint(@Nullable Endpoint endpoint) {
      this.endpoint = endpoint;
    }
    @Override
    public Endpoint getEndpoint() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePath fromJson(Json json) {
    ImmutablePath.Builder builder = ImmutablePath.builder();
    if (json.endpoint != null) {
      builder.endpoint(json.endpoint);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Path} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Path instance
   */
  public static ImmutablePath copyOf(Path instance) {
    if (instance instanceof ImmutablePath) {
      return (ImmutablePath) instance;
    }
    return ImmutablePath.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePath ImmutablePath}.
   * <pre>
   * ImmutablePath.builder()
   *    .endpoint(zeenea.connector.openapi.client.model.Endpoint | null) // nullable {@link Path#getEndpoint() endpoint}
   *    .build();
   * </pre>
   * @return A new ImmutablePath builder
   */
  public static ImmutablePath.Builder builder() {
    return new ImmutablePath.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePath ImmutablePath}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Path", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Endpoint endpoint;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Path} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Path instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Endpoint endpointValue = instance.getEndpoint();
      if (endpointValue != null) {
        endpoint(endpointValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Path#getEndpoint() endpoint} attribute.
     * @param endpoint The value for endpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("get")
    public final Builder endpoint(@Nullable Endpoint endpoint) {
      this.endpoint = endpoint;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePath ImmutablePath}.
     * @return An immutable instance of Path
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePath build() {
      return new ImmutablePath(endpoint);
    }
  }
}
