package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JsonAppResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJsonAppResponse.builder()}.
 */
@Generated(from = "JsonAppResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableJsonAppResponse implements JsonAppResponse {
  private final Schema schema;

  private ImmutableJsonAppResponse(Schema schema) {
    this.schema = schema;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @Override
  public Schema getSchema() {
    return schema;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JsonAppResponse#getSchema() schema} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJsonAppResponse withSchema(Schema value) {
    if (this.schema == value) return this;
    Schema newValue = Objects.requireNonNull(value, "schema");
    return new ImmutableJsonAppResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJsonAppResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJsonAppResponse
        && equalTo(0, (ImmutableJsonAppResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableJsonAppResponse another) {
    return schema.equals(another.schema);
  }

  /**
   * Computes a hash code from attributes: {@code schema}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + schema.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JsonAppResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JsonAppResponse{"
        + "schema=" + schema
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JsonAppResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JsonAppResponse {
    @Nullable Schema schema;
    @JsonProperty("schema")
    public void setSchema(Schema schema) {
      this.schema = schema;
    }
    @Override
    public Schema getSchema() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJsonAppResponse fromJson(Json json) {
    ImmutableJsonAppResponse.Builder builder = ImmutableJsonAppResponse.builder();
    if (json.schema != null) {
      builder.schema(json.schema);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JsonAppResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JsonAppResponse instance
   */
  public static ImmutableJsonAppResponse copyOf(JsonAppResponse instance) {
    if (instance instanceof ImmutableJsonAppResponse) {
      return (ImmutableJsonAppResponse) instance;
    }
    return ImmutableJsonAppResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJsonAppResponse ImmutableJsonAppResponse}.
   * <pre>
   * ImmutableJsonAppResponse.builder()
   *    .schema(zeenea.connector.openapi.client.model.Schema) // required {@link JsonAppResponse#getSchema() schema}
   *    .build();
   * </pre>
   * @return A new ImmutableJsonAppResponse builder
   */
  public static ImmutableJsonAppResponse.Builder builder() {
    return new ImmutableJsonAppResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJsonAppResponse ImmutableJsonAppResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JsonAppResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SCHEMA = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Schema schema;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JsonAppResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JsonAppResponse instance) {
      Objects.requireNonNull(instance, "instance");
      this.schema(instance.getSchema());
      return this;
    }

    /**
     * Initializes the value for the {@link JsonAppResponse#getSchema() schema} attribute.
     * @param schema The value for schema 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    public final Builder schema(Schema schema) {
      this.schema = Objects.requireNonNull(schema, "schema");
      initBits &= ~INIT_BIT_SCHEMA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJsonAppResponse ImmutableJsonAppResponse}.
     * @return An immutable instance of JsonAppResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJsonAppResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJsonAppResponse(schema);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SCHEMA) != 0) attributes.add("schema");
      return "Cannot build JsonAppResponse, some of required attributes are not set " + attributes;
    }
  }
}
