package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Item}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItem.builder()}.
 */
@Generated(from = "Item", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableItem implements Item {
  private final @Nullable String reference;

  private ImmutableItem(@Nullable String reference) {
    this.reference = reference;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @JsonProperty("$ref")
  @Override
  public @Nullable String getReference() {
    return reference;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Item#getReference() reference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItem withReference(@Nullable String value) {
    if (Objects.equals(this.reference, value)) return this;
    return new ImmutableItem(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItem
        && equalTo(0, (ImmutableItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableItem another) {
    return Objects.equals(reference, another.reference);
  }

  /**
   * Computes a hash code from attributes: {@code reference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(reference);
    return h;
  }

  /**
   * Prints the immutable value {@code Item} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Item{"
        + "reference=" + reference
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Item", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Item {
    @javax.annotation.Nullable String reference;
    @JsonProperty("$ref")
    public void setReference(@Nullable String reference) {
      this.reference = reference;
    }
    @Override
    public String getReference() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableItem fromJson(Json json) {
    ImmutableItem.Builder builder = ImmutableItem.builder();
    if (json.reference != null) {
      builder.reference(json.reference);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Item} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Item instance
   */
  public static ImmutableItem copyOf(Item instance) {
    if (instance instanceof ImmutableItem) {
      return (ImmutableItem) instance;
    }
    return ImmutableItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItem ImmutableItem}.
   * <pre>
   * ImmutableItem.builder()
   *    .reference(String | null) // nullable {@link Item#getReference() reference}
   *    .build();
   * </pre>
   * @return A new ImmutableItem builder
   */
  public static ImmutableItem.Builder builder() {
    return new ImmutableItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItem ImmutableItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Item", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String reference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Item} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Item instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String referenceValue = instance.getReference();
      if (referenceValue != null) {
        reference(referenceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Item#getReference() reference} attribute.
     * @param reference The value for reference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("$ref")
    public final Builder reference(@Nullable String reference) {
      this.reference = reference;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItem ImmutableItem}.
     * @return An immutable instance of Item
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItem build() {
      return new ImmutableItem(reference);
    }
  }
}
