package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Information}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInformation.builder()}.
 */
@Generated(from = "Information", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableInformation implements Information {
  private final String version;
  private final String title;
  private final @Nullable String description;

  private ImmutableInformation(
      String version,
      String title,
      @Nullable String description) {
    this.version = version;
    this.title = title;
    this.description = description;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty("title")
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Information#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInformation withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableInformation(newValue, this.title, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Information#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInformation withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableInformation(this.version, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Information#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInformation withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableInformation(this.version, this.title, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInformation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInformation
        && equalTo(0, (ImmutableInformation) another);
  }

  private boolean equalTo(int synthetic, ImmutableInformation another) {
    return version.equals(another.version)
        && title.equals(another.title)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code title}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + title.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code Information} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Information{"
        + "version=" + version
        + ", title=" + title
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Information", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Information {
    @javax.annotation.Nullable String version;
    @javax.annotation.Nullable String title;
    @javax.annotation.Nullable String description;
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableInformation fromJson(Json json) {
    ImmutableInformation.Builder builder = ImmutableInformation.builder();
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Information} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Information instance
   */
  public static ImmutableInformation copyOf(Information instance) {
    if (instance instanceof ImmutableInformation) {
      return (ImmutableInformation) instance;
    }
    return ImmutableInformation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInformation ImmutableInformation}.
   * <pre>
   * ImmutableInformation.builder()
   *    .version(String) // required {@link Information#getVersion() version}
   *    .title(String) // required {@link Information#getTitle() title}
   *    .description(String | null) // nullable {@link Information#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableInformation builder
   */
  public static ImmutableInformation.Builder builder() {
    return new ImmutableInformation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInformation ImmutableInformation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Information", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String version;
    private @javax.annotation.Nullable String title;
    private @javax.annotation.Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Information} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Information instance) {
      Objects.requireNonNull(instance, "instance");
      this.version(instance.getVersion());
      this.title(instance.getTitle());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Information#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Information#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Information#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInformation ImmutableInformation}.
     * @return An immutable instance of Information
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInformation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInformation(version, title, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      return "Cannot build Information, some of required attributes are not set " + attributes;
    }
  }
}
