package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Endpoint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEndpoint.builder()}.
 */
@Generated(from = "Endpoint", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEndpoint implements Endpoint {
  private final @Nullable String endpointDescription;
  private final @Nullable String operationId;
  private final Map<String, Response> responses;

  private ImmutableEndpoint(
      @Nullable String endpointDescription,
      @Nullable String operationId,
      Map<String, Response> responses) {
    this.endpointDescription = endpointDescription;
    this.operationId = operationId;
    this.responses = responses;
  }

  /**
   * @return The value of the {@code endpointDescription} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getEndpointDescription() {
    return endpointDescription;
  }

  /**
   * @return The value of the {@code operationId} attribute
   */
  @JsonProperty("operationId")
  @Override
  public @Nullable String getOperationId() {
    return operationId;
  }

  /**
   * @return The value of the {@code responses} attribute
   */
  @JsonProperty("responses")
  @Override
  public Map<String, Response> getResponses() {
    return responses;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Endpoint#getEndpointDescription() endpointDescription} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endpointDescription (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpoint withEndpointDescription(@Nullable String value) {
    if (Objects.equals(this.endpointDescription, value)) return this;
    return new ImmutableEndpoint(value, this.operationId, this.responses);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Endpoint#getOperationId() operationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operationId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEndpoint withOperationId(@Nullable String value) {
    if (Objects.equals(this.operationId, value)) return this;
    return new ImmutableEndpoint(this.endpointDescription, value, this.responses);
  }

  /**
   * Copy the current immutable object by replacing the {@link Endpoint#getResponses() responses} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the responses map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEndpoint withResponses(Map<String, ? extends Response> entries) {
    if (this.responses == entries) return this;
    Map<String, Response> newValue = Map.copyOf(entries);
    return new ImmutableEndpoint(this.endpointDescription, this.operationId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEndpoint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEndpoint
        && equalTo(0, (ImmutableEndpoint) another);
  }

  private boolean equalTo(int synthetic, ImmutableEndpoint another) {
    return Objects.equals(endpointDescription, another.endpointDescription)
        && Objects.equals(operationId, another.operationId)
        && responses.equals(another.responses);
  }

  /**
   * Computes a hash code from attributes: {@code endpointDescription}, {@code operationId}, {@code responses}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(endpointDescription);
    h += (h << 5) + Objects.hashCode(operationId);
    h += (h << 5) + responses.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Endpoint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Endpoint{"
        + "endpointDescription=" + endpointDescription
        + ", operationId=" + operationId
        + ", responses=" + responses
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Endpoint", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Endpoint {
    @javax.annotation.Nullable String endpointDescription;
    @javax.annotation.Nullable String operationId;
    @javax.annotation.Nullable Map<String, Response> responses = Map.of();
    @JsonProperty("description")
    public void setEndpointDescription(@Nullable String endpointDescription) {
      this.endpointDescription = endpointDescription;
    }
    @JsonProperty("operationId")
    public void setOperationId(@Nullable String operationId) {
      this.operationId = operationId;
    }
    @JsonProperty("responses")
    public void setResponses(Map<String, Response> responses) {
      this.responses = responses;
    }
    @Override
    public String getEndpointDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getOperationId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Response> getResponses() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEndpoint fromJson(Json json) {
    ImmutableEndpoint.Builder builder = ImmutableEndpoint.builder();
    if (json.endpointDescription != null) {
      builder.endpointDescription(json.endpointDescription);
    }
    if (json.operationId != null) {
      builder.operationId(json.operationId);
    }
    if (json.responses != null) {
      builder.putAllResponses(json.responses);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Endpoint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Endpoint instance
   */
  public static ImmutableEndpoint copyOf(Endpoint instance) {
    if (instance instanceof ImmutableEndpoint) {
      return (ImmutableEndpoint) instance;
    }
    return ImmutableEndpoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEndpoint ImmutableEndpoint}.
   * <pre>
   * ImmutableEndpoint.builder()
   *    .endpointDescription(String | null) // nullable {@link Endpoint#getEndpointDescription() endpointDescription}
   *    .operationId(String | null) // nullable {@link Endpoint#getOperationId() operationId}
   *    .putResponses|putAllResponses(String =&gt; zeenea.connector.openapi.client.model.Response) // {@link Endpoint#getResponses() responses} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableEndpoint builder
   */
  public static ImmutableEndpoint.Builder builder() {
    return new ImmutableEndpoint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEndpoint ImmutableEndpoint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Endpoint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String endpointDescription;
    private @javax.annotation.Nullable String operationId;
    private Map<String, Response> responses = new LinkedHashMap<String, Response>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Endpoint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Endpoint instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String endpointDescriptionValue = instance.getEndpointDescription();
      if (endpointDescriptionValue != null) {
        endpointDescription(endpointDescriptionValue);
      }
      @Nullable String operationIdValue = instance.getOperationId();
      if (operationIdValue != null) {
        operationId(operationIdValue);
      }
      putAllResponses(instance.getResponses());
      return this;
    }

    /**
     * Initializes the value for the {@link Endpoint#getEndpointDescription() endpointDescription} attribute.
     * @param endpointDescription The value for endpointDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder endpointDescription(@Nullable String endpointDescription) {
      this.endpointDescription = endpointDescription;
      return this;
    }

    /**
     * Initializes the value for the {@link Endpoint#getOperationId() operationId} attribute.
     * @param operationId The value for operationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("operationId")
    public final Builder operationId(@Nullable String operationId) {
      this.operationId = operationId;
      return this;
    }

    /**
     * Put one entry to the {@link Endpoint#getResponses() responses} map.
     * @param key The key in the responses map
     * @param value The associated value in the responses map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResponses(String key, Response value) {
      this.responses.put(
          Objects.requireNonNull(key, "responses key"),
          Objects.requireNonNull(value, value == null ? "responses value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Endpoint#getResponses() responses} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResponses(Map.Entry<String, ? extends Response> entry) {
      String k = entry.getKey();
      Response v = entry.getValue();
      this.responses.put(
          Objects.requireNonNull(k, "responses key"),
          Objects.requireNonNull(v, v == null ? "responses value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Endpoint#getResponses() responses} map. Nulls are not permitted
     * @param entries The entries that will be added to the responses map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("responses")
    public final Builder responses(Map<String, ? extends Response> entries) {
      this.responses.clear();
      return putAllResponses(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Endpoint#getResponses() responses} map. Nulls are not permitted
     * @param entries The entries that will be added to the responses map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllResponses(Map<String, ? extends Response> entries) {
      for (Map.Entry<String, ? extends Response> e : entries.entrySet()) {
        String k = e.getKey();
        Response v = e.getValue();
        this.responses.put(
            Objects.requireNonNull(k, "responses key"),
            Objects.requireNonNull(v, v == null ? "responses value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableEndpoint ImmutableEndpoint}.
     * @return An immutable instance of Endpoint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEndpoint build() {
      return new ImmutableEndpoint(endpointDescription, operationId, Map.copyOf(responses));
    }
  }
}
