package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Content}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContent.builder()}.
 */
@Generated(from = "Content", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableContent implements Content {
  private final @Nullable JsonAppResponse applicationJson;

  private ImmutableContent(
      @Nullable JsonAppResponse applicationJson) {
    this.applicationJson = applicationJson;
  }

  /**
   * @return The value of the {@code applicationJson} attribute
   */
  @JsonProperty("application/json")
  @Override
  public @Nullable JsonAppResponse getApplicationJson() {
    return applicationJson;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#getApplicationJson() applicationJson} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for applicationJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withApplicationJson(@Nullable JsonAppResponse value) {
    if (this.applicationJson == value) return this;
    return new ImmutableContent(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContent
        && equalTo(0, (ImmutableContent) another);
  }

  private boolean equalTo(int synthetic, ImmutableContent another) {
    return Objects.equals(applicationJson, another.applicationJson);
  }

  /**
   * Computes a hash code from attributes: {@code applicationJson}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationJson);
    return h;
  }

  /**
   * Prints the immutable value {@code Content} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Content{"
        + "applicationJson=" + applicationJson
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Content", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Content {
    @javax.annotation.Nullable JsonAppResponse applicationJson;
    @JsonProperty("application/json")
    public void setApplicationJson(@Nullable JsonAppResponse applicationJson) {
      this.applicationJson = applicationJson;
    }
    @Override
    public JsonAppResponse getApplicationJson() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContent fromJson(Json json) {
    ImmutableContent.Builder builder = ImmutableContent.builder();
    if (json.applicationJson != null) {
      builder.applicationJson(json.applicationJson);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Content} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Content instance
   */
  public static ImmutableContent copyOf(Content instance) {
    if (instance instanceof ImmutableContent) {
      return (ImmutableContent) instance;
    }
    return ImmutableContent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContent ImmutableContent}.
   * <pre>
   * ImmutableContent.builder()
   *    .applicationJson(zeenea.connector.openapi.client.model.JsonAppResponse | null) // nullable {@link Content#getApplicationJson() applicationJson}
   *    .build();
   * </pre>
   * @return A new ImmutableContent builder
   */
  public static ImmutableContent.Builder builder() {
    return new ImmutableContent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContent ImmutableContent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Content", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable JsonAppResponse applicationJson;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Content} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable JsonAppResponse applicationJsonValue = instance.getApplicationJson();
      if (applicationJsonValue != null) {
        applicationJson(applicationJsonValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Content#getApplicationJson() applicationJson} attribute.
     * @param applicationJson The value for applicationJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("application/json")
    public final Builder applicationJson(@Nullable JsonAppResponse applicationJson) {
      this.applicationJson = applicationJson;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContent ImmutableContent}.
     * @return An immutable instance of Content
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContent build() {
      return new ImmutableContent(applicationJson);
    }
  }
}
