package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Components}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComponents.builder()}.
 */
@Generated(from = "Components", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableComponents implements Components {
  private final Map<String, Schemas> schemas;

  private ImmutableComponents(Map<String, Schemas> schemas) {
    this.schemas = schemas;
  }

  /**
   * @return The value of the {@code schemas} attribute
   */
  @JsonProperty("schemas")
  @Override
  public Map<String, Schemas> getSchemas() {
    return schemas;
  }

  /**
   * Copy the current immutable object by replacing the {@link Components#getSchemas() schemas} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the schemas map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComponents withSchemas(Map<String, ? extends Schemas> entries) {
    if (this.schemas == entries) return this;
    Map<String, Schemas> newValue = Map.copyOf(entries);
    return new ImmutableComponents(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComponents} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComponents
        && equalTo(0, (ImmutableComponents) another);
  }

  private boolean equalTo(int synthetic, ImmutableComponents another) {
    return schemas.equals(another.schemas);
  }

  /**
   * Computes a hash code from attributes: {@code schemas}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + schemas.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Components} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Components{"
        + "schemas=" + schemas
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Components", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Components {
    @Nullable Map<String, Schemas> schemas = Map.of();
    @JsonProperty("schemas")
    public void setSchemas(Map<String, Schemas> schemas) {
      this.schemas = schemas;
    }
    @Override
    public Map<String, Schemas> getSchemas() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComponents fromJson(Json json) {
    ImmutableComponents.Builder builder = ImmutableComponents.builder();
    if (json.schemas != null) {
      builder.putAllSchemas(json.schemas);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Components} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Components instance
   */
  public static ImmutableComponents copyOf(Components instance) {
    if (instance instanceof ImmutableComponents) {
      return (ImmutableComponents) instance;
    }
    return ImmutableComponents.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComponents ImmutableComponents}.
   * <pre>
   * ImmutableComponents.builder()
   *    .putSchemas|putAllSchemas(String =&gt; zeenea.connector.openapi.client.model.Schemas) // {@link Components#getSchemas() schemas} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableComponents builder
   */
  public static ImmutableComponents.Builder builder() {
    return new ImmutableComponents.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComponents ImmutableComponents}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Components", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, Schemas> schemas = new LinkedHashMap<String, Schemas>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Components} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Components instance) {
      Objects.requireNonNull(instance, "instance");
      putAllSchemas(instance.getSchemas());
      return this;
    }

    /**
     * Put one entry to the {@link Components#getSchemas() schemas} map.
     * @param key The key in the schemas map
     * @param value The associated value in the schemas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putSchemas(String key, Schemas value) {
      this.schemas.put(
          Objects.requireNonNull(key, "schemas key"),
          Objects.requireNonNull(value, value == null ? "schemas value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Components#getSchemas() schemas} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putSchemas(Map.Entry<String, ? extends Schemas> entry) {
      String k = entry.getKey();
      Schemas v = entry.getValue();
      this.schemas.put(
          Objects.requireNonNull(k, "schemas key"),
          Objects.requireNonNull(v, v == null ? "schemas value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Components#getSchemas() schemas} map. Nulls are not permitted
     * @param entries The entries that will be added to the schemas map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Map<String, ? extends Schemas> entries) {
      this.schemas.clear();
      return putAllSchemas(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Components#getSchemas() schemas} map. Nulls are not permitted
     * @param entries The entries that will be added to the schemas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllSchemas(Map<String, ? extends Schemas> entries) {
      for (Map.Entry<String, ? extends Schemas> e : entries.entrySet()) {
        String k = e.getKey();
        Schemas v = e.getValue();
        this.schemas.put(
            Objects.requireNonNull(k, "schemas key"),
            Objects.requireNonNull(v, v == null ? "schemas value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableComponents ImmutableComponents}.
     * @return An immutable instance of Components
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComponents build() {
      return new ImmutableComponents(Map.copyOf(schemas));
    }
  }
}
