package zeenea.connector.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link AllOf}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllOf.builder()}.
 */
@Generated(from = "AllOf", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAllOf implements AllOf {
  private final @Nullable String type;
  private final @Nullable List<String> required;
  private final @Nullable Map<String, Property> properties;
  private final @Nullable String description;
  private final @Nullable String reference;

  private ImmutableAllOf(
      @Nullable String type,
      @Nullable List<String> required,
      @Nullable Map<String, Property> properties,
      @Nullable String description,
      @Nullable String reference) {
    this.type = type;
    this.required = required;
    this.properties = properties;
    this.description = description;
    this.reference = reference;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @JsonProperty("required")
  @Override
  public @Nullable List<String> getRequired() {
    return required;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public @Nullable Map<String, Property> getProperties() {
    return properties;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @JsonProperty("$ref")
  @Override
  public @Nullable String getReference() {
    return reference;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllOf#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllOf withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAllOf(value, this.required, this.properties, this.description, this.reference);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllOf#getRequired() required}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllOf withRequired(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableAllOf(this.type, null, this.properties, this.description, this.reference);
    }
    List<String> newValue = List.of(elements);
    return new ImmutableAllOf(this.type, newValue, this.properties, this.description, this.reference);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllOf#getRequired() required}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of required elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllOf withRequired(@Nullable Iterable<String> elements) {
    if (this.required == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableAllOf(this.type, newValue, this.properties, this.description, this.reference);
  }

  /**
   * Copy the current immutable object by replacing the {@link AllOf#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllOf withProperties(@Nullable Map<String, ? extends Property> entries) {
    if (this.properties == entries) return this;
    @Nullable Map<String, Property> newValue = entries == null ? null : Map.copyOf(entries);
    return new ImmutableAllOf(this.type, this.required, newValue, this.description, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllOf#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllOf withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableAllOf(this.type, this.required, this.properties, value, this.reference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AllOf#getReference() reference} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAllOf withReference(@Nullable String value) {
    if (Objects.equals(this.reference, value)) return this;
    return new ImmutableAllOf(this.type, this.required, this.properties, this.description, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllOf} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllOf
        && equalTo(0, (ImmutableAllOf) another);
  }

  private boolean equalTo(int synthetic, ImmutableAllOf another) {
    return Objects.equals(type, another.type)
        && Objects.equals(required, another.required)
        && Objects.equals(properties, another.properties)
        && Objects.equals(description, another.description)
        && Objects.equals(reference, another.reference);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code required}, {@code properties}, {@code description}, {@code reference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(required);
    h += (h << 5) + Objects.hashCode(properties);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(reference);
    return h;
  }

  /**
   * Prints the immutable value {@code AllOf} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AllOf{"
        + "type=" + type
        + ", required=" + required
        + ", properties=" + properties
        + ", description=" + description
        + ", reference=" + reference
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AllOf", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AllOf {
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable List<String> required = null;
    @javax.annotation.Nullable Map<String, Property> properties = null;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String reference;
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("required")
    public void setRequired(@Nullable List<String> required) {
      this.required = required;
    }
    @JsonProperty("properties")
    public void setProperties(@Nullable Map<String, Property> properties) {
      this.properties = properties;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("$ref")
    public void setReference(@Nullable String reference) {
      this.reference = reference;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRequired() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Property> getProperties() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getReference() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAllOf fromJson(Json json) {
    ImmutableAllOf.Builder builder = ImmutableAllOf.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.required != null) {
      builder.addAllRequired(json.required);
    }
    if (json.properties != null) {
      builder.putAllProperties(json.properties);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.reference != null) {
      builder.reference(json.reference);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AllOf} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllOf instance
   */
  public static ImmutableAllOf copyOf(AllOf instance) {
    if (instance instanceof ImmutableAllOf) {
      return (ImmutableAllOf) instance;
    }
    return ImmutableAllOf.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllOf ImmutableAllOf}.
   * <pre>
   * ImmutableAllOf.builder()
   *    .type(String | null) // nullable {@link AllOf#getType() type}
   *    .required(List&amp;lt;String&amp;gt; | null) // nullable {@link AllOf#getRequired() required}
   *    .properties(Map&amp;lt;String, zeenea.connector.openapi.client.model.Property&amp;gt; | null) // nullable {@link AllOf#getProperties() properties}
   *    .description(String | null) // nullable {@link AllOf#getDescription() description}
   *    .reference(String | null) // nullable {@link AllOf#getReference() reference}
   *    .build();
   * </pre>
   * @return A new ImmutableAllOf builder
   */
  public static ImmutableAllOf.Builder builder() {
    return new ImmutableAllOf.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllOf ImmutableAllOf}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllOf", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String type;
    private List<String> required = null;
    private Map<String, Property> properties = null;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String reference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.openapi.client.model.AllOf} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AllOf instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.openapi.client.model.ObjectSchema} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ObjectSchema instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof AllOf) {
        AllOf instance = (AllOf) object;
        @Nullable String referenceValue = instance.getReference();
        if (referenceValue != null) {
          reference(referenceValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable List<String> requiredValue = instance.getRequired();
          if (requiredValue != null) {
            addAllRequired(requiredValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Map<String, Property> propertiesValue = instance.getProperties();
          if (propertiesValue != null) {
            putAllProperties(propertiesValue);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof ObjectSchema) {
        ObjectSchema instance = (ObjectSchema) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable List<String> requiredValue = instance.getRequired();
          if (requiredValue != null) {
            addAllRequired(requiredValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Map<String, Property> propertiesValue = instance.getProperties();
          if (propertiesValue != null) {
            putAllProperties(propertiesValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AllOf#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link AllOf#getRequired() required} list.
     * @param element A required element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRequired(String element) {
      if (this.required == null) {
        this.required = new ArrayList<String>();
      }
      this.required.add(Objects.requireNonNull(element, "required element"));
      return this;
    }

    /**
     * Adds elements to {@link AllOf#getRequired() required} list.
     * @param elements An array of required elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRequired(String... elements) {
      if (this.required == null) {
        this.required = new ArrayList<String>();
      }
      for (String element : elements) {
        this.required.add(Objects.requireNonNull(element, "required element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllOf#getRequired() required} list.
     * @param elements An iterable of required elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("required")
    public final Builder required(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.required = null;
        return this;
      }
      this.required = new ArrayList<String>();
      return addAllRequired(elements);
    }

    /**
     * Adds elements to {@link AllOf#getRequired() required} list.
     * @param elements An iterable of required elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRequired(Iterable<String> elements) {
      Objects.requireNonNull(elements, "required element");
      if (this.required == null) {
        this.required = new ArrayList<String>();
      }
      for (String element : elements) {
        this.required.add(Objects.requireNonNull(element, "required element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link AllOf#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProperties(String key, Property value) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      this.properties.put(
          Objects.requireNonNull(key, "properties key"),
          Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link AllOf#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProperties(Map.Entry<String, ? extends Property> entry) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      String k = entry.getKey();
      Property v = entry.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AllOf#getProperties() properties} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("properties")
    public final Builder properties(@Nullable Map<String, ? extends Property> entries) {
      if (entries == null) {
        this.properties = null;
        return this;
      }
      this.properties = new LinkedHashMap<String, Property>();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AllOf#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProperties(Map<String, ? extends Property> entries) {
      if (this.properties == null) {
        this.properties = new LinkedHashMap<String, Property>();
      }
      for (Map.Entry<String, ? extends Property> e : entries.entrySet()) {
        String k = e.getKey();
        Property v = e.getValue();
        this.properties.put(
            Objects.requireNonNull(k, "properties key"),
            Objects.requireNonNull(v, v == null ? "properties value for key: " + k : null));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AllOf#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link AllOf#getReference() reference} attribute.
     * @param reference The value for reference (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("$ref")
    public final Builder reference(@Nullable String reference) {
      this.reference = reference;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllOf ImmutableAllOf}.
     * @return An immutable instance of AllOf
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllOf build() {
      return new ImmutableAllOf(
          type,
          required == null ? null : List.copyOf(required),
          properties == null ? null : Map.copyOf(properties),
          description,
          reference);
    }
  }
}
