/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import zeenea.connector.commons.json.JsonSerializationException;
import zeenea.connector.commons.util.StringUtil;
import zeenea.connector.commons.xml.XmlDeserializationException;
import zeenea.connector.commons.xml.XmlSerializationException;

public enum XmlMapper {
    instance;

    private static final PrettyPrinter prettyPrinter;
    private final ObjectMapper mapper = new com.fasterxml.jackson.dataformat.xml.XmlMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    public static XmlMapper of() {
        return instance;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public <T> T readValue(String xml, Class<T> klass) {
        return this.readValue(xml, this.mapper.constructType(klass));
    }

    public <T> T readValue(String xml, TypeReference<T> typeReference) {
        return this.readValue(xml, this.mapper.constructType(typeReference));
    }

    public <T> T readValue(String xml, JavaType type) {
        try {
            return (T)this.mapper.readValue(xml, type);
        }
        catch (Exception e) {
            throw new XmlDeserializationException(String.format("Failed reading string : %s", e.getMessage()), e);
        }
    }

    public <T> T readValue(InputStream inputStream, Class<T> klass) {
        return this.readValue(inputStream, this.mapper.constructType(klass));
    }

    public <T> T readValue(InputStream inputStream, TypeReference<T> typeReference) {
        return this.readValue(inputStream, this.mapper.constructType(typeReference));
    }

    public <T> T readValue(InputStream is, JavaType type) {
        try {
            return (T)this.mapper.readValue(is, type);
        }
        catch (Exception e) {
            throw new XmlDeserializationException(String.format("Failed reading input stream : %s", e.getMessage()), e);
        }
    }

    public <T> T readValue(Path path, Class<T> klass) {
        return this.readValue(path, this.mapper.constructType(klass));
    }

    public <T> T readValue(Path path, TypeReference<T> typeReference) {
        return this.readValue(path, this.mapper.constructType(typeReference));
    }

    public <T> T readValue(Path path, JavaType type) {
        return this.readValue(path.toFile(), type);
    }

    public <T> T readValue(File file, Class<T> klass) {
        return this.readValue(file, this.mapper.constructType(klass));
    }

    public <T> T readValue(File file, TypeReference<T> typeReference) {
        return this.readValue(file, this.mapper.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType type) {
        try {
            return (T)this.mapper.readValue(file, type);
        }
        catch (Exception e) {
            throw new XmlDeserializationException(String.format("Failed reading file '%s': %s", file, e.getMessage()), e);
        }
    }

    public <T> byte[] writeAsBytes(T o) {
        try {
            return this.mapper.writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new XmlSerializationException(String.format("Fails to write XML '%s' '%s'", o.getClass().getName(), o), e);
        }
    }

    public <T> String prettyPrint(T o) {
        return this.prettyPrint(o, 0);
    }

    public <T> String prettyPrint(T o, int indent) {
        try {
            return StringUtil.indent((String)this.mapper.writer(prettyPrinter).writeValueAsString(o), (int)indent);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationException(String.format("Fails to jsonify '%s' '%s'", o.getClass().getName(), o), e);
        }
    }

    static {
        prettyPrinter = new DefaultPrettyPrinter();
    }
}

