/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Option;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.db.DbTable;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.util.ObjectUtil;
import zeenea.connector.commons.util.StringUtil;
import zeenea.connector.commons.zeepath.ZeePaths;
import zeenea.connector.source.InternItemReference;
import zeenea.connector.source.ZeePath;

public class DbReferenceFactory
implements AutoCloseable {
    private static final SimpleLogger log = SimpleLogger.of(DbReferenceFactory.class);
    private final Set<String> connectionAliases = new HashSet<String>();
    @NotNull
    private final String connectorPrefix;
    @NotNull
    private final String connectionCode;

    public DbReferenceFactory(@NotNull String connectorPrefix, @NotNull String connectionCode) {
        this.connectorPrefix = connectorPrefix;
        this.connectionCode = connectionCode;
    }

    public Set<String> connectionAliases() {
        return Collections.unmodifiableSet(this.connectionAliases);
    }

    @Override
    public void close() {
        if (!this.connectionAliases.isEmpty()) {
            String message = this.connectionAliases.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    - ", "Links to items from external connections have been found." + System.lineSeparator() + "Automatic lineage can be enabled for these items by adding these values" + System.lineSeparator() + "as aliases in their corresponding configuration files." + System.lineSeparator() + "    - ", ""));
            log.entry(this.connectorPrefix + "_lineage_used_connection_aliases").with("connection", this.connectionCode).body("Aliases", message).info();
        }
    }

    @Nullable
    public InternItemReference itemReference(DbTable table, boolean multiEnabled) {
        List<String> prefix;
        if (ObjectUtil.anyNull(table, new Object[]{table.engine(), table.table()})) {
            return null;
        }
        DbEngine engine = table.engine();
        if (!engine.has(DbEngine.Feature.NO_HOST) && table.host() == null) {
            return null;
        }
        if (!engine.has(DbEngine.Feature.NO_DB) && !engine.has(DbEngine.Feature.OPTIONAL_DB) && table.database() == null) {
            return null;
        }
        if (!(engine.has(DbEngine.Feature.NO_SCHEMA) || engine.has(DbEngine.Feature.DEFAULT_SCHEMA) || engine.has(DbEngine.Feature.OPTIONAL_SCHEMA) || table.schema() != null)) {
            return null;
        }
        StringBuilder alias = new StringBuilder();
        ArrayList<String> path = new ArrayList<String>();
        if (!engine.has(DbEngine.Feature.NO_HOST)) {
            alias.append(table.host());
            if (!engine.has(DbEngine.Feature.FIXED_PORT)) {
                alias.append(':');
                alias.append(table.port());
            }
        }
        if (engine.has(DbEngine.Feature.PREFIXED) && (prefix = table.prefix()) != null) {
            path.addAll(prefix);
        }
        String database = table.database();
        if (!engine.has(DbEngine.Feature.NO_DB) && database != null) {
            if (engine.has(DbEngine.Feature.MULTI_DB) || engine.has(DbEngine.Feature.OPTIONAL_MULTI_DB) && multiEnabled) {
                path.add(database);
            } else {
                alias.append('/');
                alias.append(database);
            }
        }
        if (!engine.has(DbEngine.Feature.NO_SCHEMA)) {
            String schema = table.schema();
            if (schema != null) {
                path.add(schema);
            } else if (engine.has(DbEngine.Feature.DEFAULT_SCHEMA)) {
                path.add(engine.defaultSchema());
            }
        }
        path.add(table.table());
        String connectionAlias = alias.toString();
        if (StringUtil.nonEmpty(connectionAlias)) {
            this.connectionAliases.add(connectionAlias);
            return InternItemReference.apply((ZeePath)ZeePaths.zeePath(path), (Option)Option.apply((Object)connectionAlias));
        }
        return InternItemReference.apply((ZeePath)ZeePaths.zeePath(path));
    }
}

