/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api;

import java.net.URI;
import java.net.URISyntaxException;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;

public class ApiUrl {
    private static final SimpleLogger log = SimpleLogger.of(ApiUrl.class);

    public static URI normalize(TracingContext ctx, URI base) {
        if (base.isOpaque()) {
            throw log.entry("api_url_normalize_opaque_url").context(ctx).with("url", base).exception(IllegalArgumentException::new);
        }
        if (!base.isAbsolute()) {
            throw log.entry("api_url_normalize_relative_url").context(ctx).with("url", base).exception(IllegalArgumentException::new);
        }
        String path = base.getPath();
        if (path == null || path.isEmpty()) {
            return base.resolve("/");
        }
        if (path.charAt(path.length() - 1) == '/') {
            return base;
        }
        try {
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), base.getPath() + "/", base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException e) {
            throw log.entry("api_url_normalize_failure").context(ctx).with("url", base).exception(e, IllegalArgumentException::new);
        }
    }
}

