/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;

class ContentTypeUtil {
    public static final ContentType APPLICATION_YAML = ContentType.parse((CharSequence)"application/yaml");
    public static final Pattern REGEX_APPLICATION_YAML = Pattern.compile("^[a-zA-Z0-9.-]+/[a-zA-Z0-9.-]+\\+yaml$");
    public static final Pattern REGEX_APPLICATION_JSON = Pattern.compile("^[a-zA-Z0-9.-]+/[a-zA-Z0-9.-]+\\+json$");
    private static final ContentType APPLICATION_YAML_OLD = ContentType.parse((CharSequence)"application/x-yaml");
    private static final ContentType TEXT_YAML_OLD = ContentType.parse((CharSequence)"text/x-yaml");
    private static final ContentType TEXT_YAML = ContentType.parse((CharSequence)"text/yaml");
    public static final List<ContentType> ALL_YAML_TYPES = Arrays.asList(APPLICATION_YAML, APPLICATION_YAML_OLD, TEXT_YAML_OLD, TEXT_YAML);
    public static final ContentType APPLICATION_ZIP = ContentType.parse((CharSequence)"application/zip");

    ContentTypeUtil() {
    }

    public static ContentType contentType(HttpEntity entity) {
        String contentType = entity.getContentType();
        return contentType != null ? ContentType.parse((CharSequence)contentType) : ContentType.DEFAULT_TEXT;
    }

    public static String principalType(String mimeType) {
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex < 0) {
            throw new IllegalStateException("Mime type has no principal and sub type.");
        }
        return mimeType.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
    }

    public static String subType(String mimeType) {
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex < 0) {
            throw new IllegalStateException("Mime type has no principal and sub type.");
        }
        int paramsIndex = mimeType.indexOf(59);
        if (paramsIndex >= 0) {
            return mimeType.substring(slashIndex + 1, paramsIndex).trim().toLowerCase(Locale.ENGLISH);
        }
        return mimeType.substring(slashIndex + 1).trim().toLowerCase(Locale.ENGLISH);
    }

    public static Set<String> subTypeSet(String mimeType) {
        return new HashSet<String>(Arrays.asList(ContentTypeUtil.subType(mimeType).split("\\+")));
    }
}

