package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link SingleVisual}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSingleVisual.builder()}.
 */
@Generated(from = "SingleVisual", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSingleVisual implements SingleVisual {
  private final @Nullable PrototypeQuery prototypeQuery;

  private ImmutableSingleVisual(
      @Nullable PrototypeQuery prototypeQuery) {
    this.prototypeQuery = prototypeQuery;
  }

  /**
   * @return The value of the {@code prototypeQuery} attribute
   */
  @JsonProperty("prototypeQuery")
  @Override
  public @Nullable PrototypeQuery getPrototypeQuery() {
    return prototypeQuery;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SingleVisual#getPrototypeQuery() prototypeQuery} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prototypeQuery (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSingleVisual withPrototypeQuery(@Nullable PrototypeQuery value) {
    if (this.prototypeQuery == value) return this;
    return new ImmutableSingleVisual(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSingleVisual} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSingleVisual
        && equalTo(0, (ImmutableSingleVisual) another);
  }

  private boolean equalTo(int synthetic, ImmutableSingleVisual another) {
    return Objects.equals(prototypeQuery, another.prototypeQuery);
  }

  /**
   * Computes a hash code from attributes: {@code prototypeQuery}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(prototypeQuery);
    return h;
  }

  /**
   * Prints the immutable value {@code SingleVisual} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SingleVisual{"
        + "prototypeQuery=" + prototypeQuery
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SingleVisual", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SingleVisual {
    @javax.annotation.Nullable PrototypeQuery prototypeQuery;
    @JsonProperty("prototypeQuery")
    public void setPrototypeQuery(@Nullable PrototypeQuery prototypeQuery) {
      this.prototypeQuery = prototypeQuery;
    }
    @Override
    public PrototypeQuery getPrototypeQuery() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSingleVisual fromJson(Json json) {
    ImmutableSingleVisual.Builder builder = ImmutableSingleVisual.builder();
    if (json.prototypeQuery != null) {
      builder.prototypeQuery(json.prototypeQuery);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SingleVisual} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SingleVisual instance
   */
  public static ImmutableSingleVisual copyOf(SingleVisual instance) {
    if (instance instanceof ImmutableSingleVisual) {
      return (ImmutableSingleVisual) instance;
    }
    return ImmutableSingleVisual.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSingleVisual ImmutableSingleVisual}.
   * <pre>
   * ImmutableSingleVisual.builder()
   *    .prototypeQuery(zeenea.connector.powerbi.v2.client.pbix.PrototypeQuery | null) // nullable {@link SingleVisual#getPrototypeQuery() prototypeQuery}
   *    .build();
   * </pre>
   * @return A new ImmutableSingleVisual builder
   */
  public static ImmutableSingleVisual.Builder builder() {
    return new ImmutableSingleVisual.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSingleVisual ImmutableSingleVisual}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SingleVisual", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable PrototypeQuery prototypeQuery;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SingleVisual} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SingleVisual instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable PrototypeQuery prototypeQueryValue = instance.getPrototypeQuery();
      if (prototypeQueryValue != null) {
        prototypeQuery(prototypeQueryValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SingleVisual#getPrototypeQuery() prototypeQuery} attribute.
     * @param prototypeQuery The value for prototypeQuery (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("prototypeQuery")
    public final Builder prototypeQuery(@Nullable PrototypeQuery prototypeQuery) {
      this.prototypeQuery = prototypeQuery;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSingleVisual ImmutableSingleVisual}.
     * @return An immutable instance of SingleVisual
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSingleVisual build() {
      return new ImmutableSingleVisual(prototypeQuery);
    }
  }
}
