package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Select}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSelect.builder()}.
 */
@Generated(from = "Select", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSelect implements Select {
  private final @Nullable Aggregation aggregation;
  private final @Nullable Column column;
  private final String name;
  private final @Nullable String nativeReferenceName;

  private ImmutableSelect(
      @Nullable Aggregation aggregation,
      @Nullable Column column,
      String name,
      @Nullable String nativeReferenceName) {
    this.aggregation = aggregation;
    this.column = column;
    this.name = name;
    this.nativeReferenceName = nativeReferenceName;
  }

  /**
   * @return The value of the {@code aggregation} attribute
   */
  @JsonProperty("Aggregation")
  @Override
  public @Nullable Aggregation getAggregation() {
    return aggregation;
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @JsonProperty("Column")
  @Override
  public @Nullable Column getColumn() {
    return column;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code nativeReferenceName} attribute
   */
  @JsonProperty("NativeReferenceName")
  @Override
  public @Nullable String getNativeReferenceName() {
    return nativeReferenceName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Select#getAggregation() aggregation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for aggregation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelect withAggregation(@Nullable Aggregation value) {
    if (this.aggregation == value) return this;
    return new ImmutableSelect(value, this.column, this.name, this.nativeReferenceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Select#getColumn() column} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for column (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelect withColumn(@Nullable Column value) {
    if (this.column == value) return this;
    return new ImmutableSelect(this.aggregation, value, this.name, this.nativeReferenceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Select#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelect withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSelect(this.aggregation, this.column, newValue, this.nativeReferenceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Select#getNativeReferenceName() nativeReferenceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeReferenceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSelect withNativeReferenceName(@Nullable String value) {
    if (Objects.equals(this.nativeReferenceName, value)) return this;
    return new ImmutableSelect(this.aggregation, this.column, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSelect} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSelect
        && equalTo(0, (ImmutableSelect) another);
  }

  private boolean equalTo(int synthetic, ImmutableSelect another) {
    return Objects.equals(aggregation, another.aggregation)
        && Objects.equals(column, another.column)
        && name.equals(another.name)
        && Objects.equals(nativeReferenceName, another.nativeReferenceName);
  }

  /**
   * Computes a hash code from attributes: {@code aggregation}, {@code column}, {@code name}, {@code nativeReferenceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(aggregation);
    h += (h << 5) + Objects.hashCode(column);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(nativeReferenceName);
    return h;
  }

  /**
   * Prints the immutable value {@code Select} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Select{"
        + "aggregation=" + aggregation
        + ", column=" + column
        + ", name=" + name
        + ", nativeReferenceName=" + nativeReferenceName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Select", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Select {
    @javax.annotation.Nullable Aggregation aggregation;
    @javax.annotation.Nullable Column column;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String nativeReferenceName;
    @JsonProperty("Aggregation")
    public void setAggregation(@Nullable Aggregation aggregation) {
      this.aggregation = aggregation;
    }
    @JsonProperty("Column")
    public void setColumn(@Nullable Column column) {
      this.column = column;
    }
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("NativeReferenceName")
    public void setNativeReferenceName(@Nullable String nativeReferenceName) {
      this.nativeReferenceName = nativeReferenceName;
    }
    @Override
    public Aggregation getAggregation() { throw new UnsupportedOperationException(); }
    @Override
    public Column getColumn() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getNativeReferenceName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSelect fromJson(Json json) {
    ImmutableSelect.Builder builder = ImmutableSelect.builder();
    if (json.aggregation != null) {
      builder.aggregation(json.aggregation);
    }
    if (json.column != null) {
      builder.column(json.column);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nativeReferenceName != null) {
      builder.nativeReferenceName(json.nativeReferenceName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Select} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Select instance
   */
  public static ImmutableSelect copyOf(Select instance) {
    if (instance instanceof ImmutableSelect) {
      return (ImmutableSelect) instance;
    }
    return ImmutableSelect.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSelect ImmutableSelect}.
   * <pre>
   * ImmutableSelect.builder()
   *    .aggregation(zeenea.connector.powerbi.v2.client.pbix.Aggregation | null) // nullable {@link Select#getAggregation() aggregation}
   *    .column(zeenea.connector.powerbi.v2.client.pbix.Column | null) // nullable {@link Select#getColumn() column}
   *    .name(String) // required {@link Select#getName() name}
   *    .nativeReferenceName(String | null) // nullable {@link Select#getNativeReferenceName() nativeReferenceName}
   *    .build();
   * </pre>
   * @return A new ImmutableSelect builder
   */
  public static ImmutableSelect.Builder builder() {
    return new ImmutableSelect.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSelect ImmutableSelect}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Select", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable Aggregation aggregation;
    private @javax.annotation.Nullable Column column;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String nativeReferenceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Select} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Select instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Aggregation aggregationValue = instance.getAggregation();
      if (aggregationValue != null) {
        aggregation(aggregationValue);
      }
      @Nullable Column columnValue = instance.getColumn();
      if (columnValue != null) {
        column(columnValue);
      }
      this.name(instance.getName());
      @Nullable String nativeReferenceNameValue = instance.getNativeReferenceName();
      if (nativeReferenceNameValue != null) {
        nativeReferenceName(nativeReferenceNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Select#getAggregation() aggregation} attribute.
     * @param aggregation The value for aggregation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Aggregation")
    public final Builder aggregation(@Nullable Aggregation aggregation) {
      this.aggregation = aggregation;
      return this;
    }

    /**
     * Initializes the value for the {@link Select#getColumn() column} attribute.
     * @param column The value for column (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Column")
    public final Builder column(@Nullable Column column) {
      this.column = column;
      return this;
    }

    /**
     * Initializes the value for the {@link Select#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Select#getNativeReferenceName() nativeReferenceName} attribute.
     * @param nativeReferenceName The value for nativeReferenceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NativeReferenceName")
    public final Builder nativeReferenceName(@Nullable String nativeReferenceName) {
      this.nativeReferenceName = nativeReferenceName;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSelect ImmutableSelect}.
     * @return An immutable instance of Select
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSelect build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSelect(aggregation, column, name, nativeReferenceName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Select, some of required attributes are not set " + attributes;
    }
  }
}
