package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrototypeQuery}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrototypeQuery.builder()}.
 */
@Generated(from = "PrototypeQuery", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutablePrototypeQuery implements PrototypeQuery {
  private final List<From> froms;
  private final List<Select> selects;

  private ImmutablePrototypeQuery(
      List<From> froms,
      List<Select> selects) {
    this.froms = froms;
    this.selects = selects;
  }

  /**
   * @return The value of the {@code froms} attribute
   */
  @JsonProperty("From")
  @Override
  public List<From> getFroms() {
    return froms;
  }

  /**
   * @return The value of the {@code selects} attribute
   */
  @JsonProperty("Select")
  @Override
  public List<Select> getSelects() {
    return selects;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrototypeQuery#getFroms() froms}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrototypeQuery withFroms(From... elements) {
    List<From> newValue = List.of(elements);
    return new ImmutablePrototypeQuery(newValue, this.selects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrototypeQuery#getFroms() froms}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of froms elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrototypeQuery withFroms(Iterable<? extends From> elements) {
    if (this.froms == elements) return this;
    List<From> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends From>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutablePrototypeQuery(newValue, this.selects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrototypeQuery#getSelects() selects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrototypeQuery withSelects(Select... elements) {
    List<Select> newValue = List.of(elements);
    return new ImmutablePrototypeQuery(this.froms, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrototypeQuery#getSelects() selects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of selects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrototypeQuery withSelects(Iterable<? extends Select> elements) {
    if (this.selects == elements) return this;
    List<Select> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Select>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutablePrototypeQuery(this.froms, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrototypeQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrototypeQuery
        && equalTo(0, (ImmutablePrototypeQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrototypeQuery another) {
    return froms.equals(another.froms)
        && selects.equals(another.selects);
  }

  /**
   * Computes a hash code from attributes: {@code froms}, {@code selects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + froms.hashCode();
    h += (h << 5) + selects.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PrototypeQuery} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PrototypeQuery{"
        + "froms=" + froms
        + ", selects=" + selects
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PrototypeQuery", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PrototypeQuery {
    @Nullable List<From> froms = List.of();
    @Nullable List<Select> selects = List.of();
    @JsonProperty("From")
    public void setFroms(List<From> froms) {
      this.froms = froms;
    }
    @JsonProperty("Select")
    public void setSelects(List<Select> selects) {
      this.selects = selects;
    }
    @Override
    public List<From> getFroms() { throw new UnsupportedOperationException(); }
    @Override
    public List<Select> getSelects() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePrototypeQuery fromJson(Json json) {
    ImmutablePrototypeQuery.Builder builder = ImmutablePrototypeQuery.builder();
    if (json.froms != null) {
      builder.addAllFroms(json.froms);
    }
    if (json.selects != null) {
      builder.addAllSelects(json.selects);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PrototypeQuery} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrototypeQuery instance
   */
  public static ImmutablePrototypeQuery copyOf(PrototypeQuery instance) {
    if (instance instanceof ImmutablePrototypeQuery) {
      return (ImmutablePrototypeQuery) instance;
    }
    return ImmutablePrototypeQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrototypeQuery ImmutablePrototypeQuery}.
   * <pre>
   * ImmutablePrototypeQuery.builder()
   *    .addFroms|addAllFroms(zeenea.connector.powerbi.v2.client.pbix.From) // {@link PrototypeQuery#getFroms() froms} elements
   *    .addSelects|addAllSelects(zeenea.connector.powerbi.v2.client.pbix.Select) // {@link PrototypeQuery#getSelects() selects} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePrototypeQuery builder
   */
  public static ImmutablePrototypeQuery.Builder builder() {
    return new ImmutablePrototypeQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrototypeQuery ImmutablePrototypeQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrototypeQuery", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<From> froms = new ArrayList<From>();
    private List<Select> selects = new ArrayList<Select>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrototypeQuery} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PrototypeQuery instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFroms(instance.getFroms());
      addAllSelects(instance.getSelects());
      return this;
    }

    /**
     * Adds one element to {@link PrototypeQuery#getFroms() froms} list.
     * @param element A froms element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFroms(From element) {
      this.froms.add(Objects.requireNonNull(element, "froms element"));
      return this;
    }

    /**
     * Adds elements to {@link PrototypeQuery#getFroms() froms} list.
     * @param elements An array of froms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFroms(From... elements) {
      for (From element : elements) {
        this.froms.add(Objects.requireNonNull(element, "froms element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PrototypeQuery#getFroms() froms} list.
     * @param elements An iterable of froms elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("From")
    public final Builder froms(Iterable<? extends From> elements) {
      this.froms.clear();
      return addAllFroms(elements);
    }

    /**
     * Adds elements to {@link PrototypeQuery#getFroms() froms} list.
     * @param elements An iterable of froms elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFroms(Iterable<? extends From> elements) {
      for (From element : elements) {
        this.froms.add(Objects.requireNonNull(element, "froms element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PrototypeQuery#getSelects() selects} list.
     * @param element A selects element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelects(Select element) {
      this.selects.add(Objects.requireNonNull(element, "selects element"));
      return this;
    }

    /**
     * Adds elements to {@link PrototypeQuery#getSelects() selects} list.
     * @param elements An array of selects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelects(Select... elements) {
      for (Select element : elements) {
        this.selects.add(Objects.requireNonNull(element, "selects element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PrototypeQuery#getSelects() selects} list.
     * @param elements An iterable of selects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Select")
    public final Builder selects(Iterable<? extends Select> elements) {
      this.selects.clear();
      return addAllSelects(elements);
    }

    /**
     * Adds elements to {@link PrototypeQuery#getSelects() selects} list.
     * @param elements An iterable of selects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSelects(Iterable<? extends Select> elements) {
      for (Select element : elements) {
        this.selects.add(Objects.requireNonNull(element, "selects element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrototypeQuery ImmutablePrototypeQuery}.
     * @return An immutable instance of PrototypeQuery
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrototypeQuery build() {
      return new ImmutablePrototypeQuery(List.copyOf(froms), List.copyOf(selects));
    }
  }
}
