package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Layout}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLayout.builder()}.
 */
@Generated(from = "Layout", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableLayout implements Layout {
  private final List<Section> sections;

  private ImmutableLayout(List<Section> sections) {
    this.sections = sections;
  }

  /**
   * @return The value of the {@code sections} attribute
   */
  @JsonProperty("sections")
  @Override
  public List<Section> getSections() {
    return sections;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Layout#getSections() sections}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLayout withSections(Section... elements) {
    List<Section> newValue = List.of(elements);
    return new ImmutableLayout(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Layout#getSections() sections}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sections elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLayout withSections(Iterable<? extends Section> elements) {
    if (this.sections == elements) return this;
    List<Section> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Section>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableLayout(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLayout} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLayout
        && equalTo(0, (ImmutableLayout) another);
  }

  private boolean equalTo(int synthetic, ImmutableLayout another) {
    return sections.equals(another.sections);
  }

  /**
   * Computes a hash code from attributes: {@code sections}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sections.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Layout} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Layout{"
        + "sections=" + sections
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Layout", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Layout {
    @Nullable List<Section> sections = List.of();
    @JsonProperty("sections")
    public void setSections(List<Section> sections) {
      this.sections = sections;
    }
    @Override
    public List<Section> getSections() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLayout fromJson(Json json) {
    ImmutableLayout.Builder builder = ImmutableLayout.builder();
    if (json.sections != null) {
      builder.addAllSections(json.sections);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Layout} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Layout instance
   */
  public static ImmutableLayout copyOf(Layout instance) {
    if (instance instanceof ImmutableLayout) {
      return (ImmutableLayout) instance;
    }
    return ImmutableLayout.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLayout ImmutableLayout}.
   * <pre>
   * ImmutableLayout.builder()
   *    .addSections|addAllSections(zeenea.connector.powerbi.v2.client.pbix.Section) // {@link Layout#getSections() sections} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLayout builder
   */
  public static ImmutableLayout.Builder builder() {
    return new ImmutableLayout.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLayout ImmutableLayout}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Layout", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Section> sections = new ArrayList<Section>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Layout} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Layout instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSections(instance.getSections());
      return this;
    }

    /**
     * Adds one element to {@link Layout#getSections() sections} list.
     * @param element A sections element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSections(Section element) {
      this.sections.add(Objects.requireNonNull(element, "sections element"));
      return this;
    }

    /**
     * Adds elements to {@link Layout#getSections() sections} list.
     * @param elements An array of sections elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSections(Section... elements) {
      for (Section element : elements) {
        this.sections.add(Objects.requireNonNull(element, "sections element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Layout#getSections() sections} list.
     * @param elements An iterable of sections elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sections")
    public final Builder sections(Iterable<? extends Section> elements) {
      this.sections.clear();
      return addAllSections(elements);
    }

    /**
     * Adds elements to {@link Layout#getSections() sections} list.
     * @param elements An iterable of sections elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSections(Iterable<? extends Section> elements) {
      for (Section element : elements) {
        this.sections.add(Objects.requireNonNull(element, "sections element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableLayout ImmutableLayout}.
     * @return An immutable instance of Layout
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLayout build() {
      return new ImmutableLayout(List.copyOf(sections));
    }
  }
}
