package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link From}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFrom.builder()}.
 */
@Generated(from = "From", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFrom implements From {
  private final String name;
  private final String entity;

  private ImmutableFrom(String name, String entity) {
    this.name = name;
    this.entity = entity;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code entity} attribute
   */
  @JsonProperty("Entity")
  @Override
  public String getEntity() {
    return entity;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link From#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFrom withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFrom(newValue, this.entity);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link From#getEntity() entity} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for entity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFrom withEntity(String value) {
    String newValue = Objects.requireNonNull(value, "entity");
    if (this.entity.equals(newValue)) return this;
    return new ImmutableFrom(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFrom} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFrom
        && equalTo(0, (ImmutableFrom) another);
  }

  private boolean equalTo(int synthetic, ImmutableFrom another) {
    return name.equals(another.name)
        && entity.equals(another.entity);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code entity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + entity.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code From} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "From{"
        + "name=" + name
        + ", entity=" + entity
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "From", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements From {
    @Nullable String name;
    @Nullable String entity;
    @JsonProperty("Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("Entity")
    public void setEntity(String entity) {
      this.entity = entity;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getEntity() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFrom fromJson(Json json) {
    ImmutableFrom.Builder builder = ImmutableFrom.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link From} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable From instance
   */
  public static ImmutableFrom copyOf(From instance) {
    if (instance instanceof ImmutableFrom) {
      return (ImmutableFrom) instance;
    }
    return ImmutableFrom.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFrom ImmutableFrom}.
   * <pre>
   * ImmutableFrom.builder()
   *    .name(String) // required {@link From#getName() name}
   *    .entity(String) // required {@link From#getEntity() entity}
   *    .build();
   * </pre>
   * @return A new ImmutableFrom builder
   */
  public static ImmutableFrom.Builder builder() {
    return new ImmutableFrom.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFrom ImmutableFrom}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "From", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ENTITY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String entity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code From} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(From instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.entity(instance.getEntity());
      return this;
    }

    /**
     * Initializes the value for the {@link From#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link From#getEntity() entity} attribute.
     * @param entity The value for entity 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Entity")
    public final Builder entity(String entity) {
      this.entity = Objects.requireNonNull(entity, "entity");
      initBits &= ~INIT_BIT_ENTITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFrom ImmutableFrom}.
     * @return An immutable instance of From
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFrom build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFrom(name, entity);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ENTITY) != 0) attributes.add("entity");
      return "Cannot build From, some of required attributes are not set " + attributes;
    }
  }
}
