package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableColumn implements Column {
  private final Expression expression;
  private final String property;

  private ImmutableColumn(Expression expression, String property) {
    this.expression = expression;
    this.property = property;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("Expression")
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * @return The value of the {@code property} attribute
   */
  @JsonProperty("Property")
  @Override
  public String getProperty() {
    return property;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableColumn(newValue, this.property);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getProperty() property} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for property
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withProperty(String value) {
    String newValue = Objects.requireNonNull(value, "property");
    if (this.property.equals(newValue)) return this;
    return new ImmutableColumn(this.expression, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo(0, (ImmutableColumn) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumn another) {
    return expression.equals(another.expression)
        && property.equals(another.property);
  }

  /**
   * Computes a hash code from attributes: {@code expression}, {@code property}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + expression.hashCode();
    h += (h << 5) + property.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Column{"
        + "expression=" + expression
        + ", property=" + property
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Column", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Column {
    @Nullable Expression expression;
    @Nullable String property;
    @JsonProperty("Expression")
    public void setExpression(Expression expression) {
      this.expression = expression;
    }
    @JsonProperty("Property")
    public void setProperty(String property) {
      this.property = property;
    }
    @Override
    public Expression getExpression() { throw new UnsupportedOperationException(); }
    @Override
    public String getProperty() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableColumn fromJson(Json json) {
    ImmutableColumn.Builder builder = ImmutableColumn.builder();
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    if (json.property != null) {
      builder.property(json.property);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .expression(zeenea.connector.powerbi.v2.client.pbix.Expression) // required {@link Column#getExpression() expression}
   *    .property(String) // required {@link Column#getProperty() property}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private static final long INIT_BIT_PROPERTY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Expression expression;
    private @Nullable String property;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Column} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      this.expression(instance.getExpression());
      this.property(instance.getProperty());
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Expression")
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getProperty() property} attribute.
     * @param property The value for property 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Property")
    public final Builder property(String property) {
      this.property = Objects.requireNonNull(property, "property");
      initBits &= ~INIT_BIT_PROPERTY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(expression, property);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      if ((initBits & INIT_BIT_PROPERTY) != 0) attributes.add("property");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
