/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.zeepath;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.ObjectUtil;
import zeenea.connector.commons.zeepath.InvalidZeePathException;
import zeenea.connector.commons.zeepath.ParsedRef;
import zeenea.connector.commons.zeepath.PathParser;
import zeenea.connector.commons.zeepath.PathParserWithContext;
import zeenea.connector.source.ZeePath;

public class ZeePathProcessor<T, R> {
    private static final SimpleLogger log = SimpleLogger.of(ZeePathProcessor.class);
    @NotNull
    private final String action;
    @NotNull
    private final PathParserWithContext<T> parser;
    @NotNull
    private final Predicate<? super T> filter;
    @NotNull
    private final BiFunction<TracingContext, ? super T, R> processor;
    @NotNull
    private final Supplier<? extends R> defaultResult;
    @NotNull
    private final OnError onError;

    private ZeePathProcessor(Builder3<T, R> builder) {
        this.action = Objects.requireNonNull(builder.action);
        this.parser = Objects.requireNonNull(builder.parser);
        this.filter = Objects.requireNonNull(builder.filter);
        this.processor = Objects.requireNonNull(builder.processor);
        this.defaultResult = Objects.requireNonNull(builder.defaultResult);
        this.onError = ObjectUtil.defaultTo(builder.onError, OnError.RETURN_DEFAULT);
    }

    public static Builder builder(@NotNull String action) {
        return new Builder(action);
    }

    private ParsedRef<T> parse(TracingContext ctx, ZeePath path) {
        try {
            T itemRef = this.parser.parse(ctx, path);
            if (this.filter.test(itemRef)) {
                return ParsedRef.supported(path, itemRef);
            }
            return ParsedRef.ignored(path);
        }
        catch (InvalidZeePathException e) {
            return ParsedRef.invalid(path, e);
        }
    }

    public R process(TracingContext ctx, ZeePath path) {
        log.entry(this.action + "_prestart").context(ctx).debug();
        ParsedRef<T> parsedRef = this.parse(ctx, path);
        if (parsedRef.isIgnored()) {
            log.entry(this.action + "_prestart_not_report").context(ctx).debug();
            return this.defaultResult.get();
        }
        log.entry(this.action + "_start").context(ctx).info();
        if (parsedRef.isInvalid()) {
            log.entry(this.action + "_invalid_path").context(ctx).quiet().error(parsedRef.getException());
            return this.defaultResult.get();
        }
        try {
            R result = this.processor.apply(ctx, (TracingContext)parsedRef.get());
            log.entry(this.action + "_success").context(ctx).info();
            return result;
        }
        catch (Exception e) {
            log.entry(this.action + "_failure").context(ctx).error(e);
            if (this.onError == OnError.RETHROW) {
                throw e;
            }
            return this.defaultResult.get();
        }
    }

    public static enum OnError {
        RETURN_DEFAULT,
        RETHROW;

    }

    public static class Builder3<T, R> {
        @NotNull
        private final String action;
        @NotNull
        private final PathParserWithContext<T> parser;
        @Nullable
        private final Predicate<? super T> filter;
        @NotNull
        private final BiFunction<TracingContext, ? super T, R> processor;
        @NotNull
        private Supplier<? extends R> defaultResult = () -> null;
        @Nullable
        private OnError onError;

        private Builder3(Builder2<T> builder, @NotNull BiFunction<TracingContext, ? super T, R> processor) {
            this.action = builder.action;
            this.parser = builder.parser;
            this.filter = builder.filter;
            this.processor = processor;
        }

        public Builder3<T, R> defaultResult(Supplier<? extends R> defaultResult) {
            this.defaultResult = defaultResult != null ? defaultResult : () -> null;
            return this;
        }

        public Builder3<T, R> onError(@Nullable OnError onError) {
            this.onError = onError;
            return this;
        }

        public ZeePathProcessor<T, R> build() {
            return new ZeePathProcessor(this);
        }
    }

    public static class Builder2<T> {
        @NotNull
        private final String action;
        @NotNull
        private final PathParserWithContext<T> parser;
        @NotNull
        private Predicate<? super T> filter = __ -> true;

        private Builder2(Builder builder, @NotNull PathParserWithContext<T> parser) {
            this.action = builder.action;
            this.parser = parser;
        }

        public Builder2<T> filter(Predicate<? super T> filter) {
            this.filter = filter != null ? filter : __ -> true;
            return this;
        }

        public <R> Builder3<T, R> processor(@NotNull BiFunction<TracingContext, ? super T, R> processor) {
            return new Builder3<T, R>(this, Objects.requireNonNull(processor));
        }

        public <R> Builder3<T, R> processor(@NotNull Function<? super T, R> processor) {
            Objects.requireNonNull(processor);
            return new Builder3<Object, Object>(this, (__, ref) -> processor.apply(ref));
        }
    }

    public static class Builder {
        private final String action;

        private Builder(@NotNull String action) {
            this.action = Objects.requireNonNull(action);
        }

        public <T> Builder2<T> parser(@NotNull PathParserWithContext<T> parser) {
            return new Builder2<T>(this, Objects.requireNonNull(parser));
        }

        public <T> Builder2<T> parser(@NotNull PathParser<T> parser) {
            Objects.requireNonNull(parser);
            return this.parser((TracingContext __, ZeePath p) -> parser.parse(p));
        }
    }
}

