/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zeenea.connector.commons.cache.BTreeFindResult;
import zeenea.connector.commons.cache.BTreeLeafEntry;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeLeafPointer;
import zeenea.connector.commons.cache.BTreeNodeEntry;
import zeenea.connector.commons.cache.BTreeNodePage;
import zeenea.connector.commons.cache.BTreeNodePointer;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.BTreePointer;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CacheEntry;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.DataPage;
import zeenea.connector.commons.cache.TableDesc;

public final class ZeeCacheTableWriter {
    private static final Logger log = LoggerFactory.getLogger(ZeeCacheTableWriter.class);
    @NotNull
    private final CacheData tableKey;
    @NotNull
    private final CachePageLoader pageLoader;
    @NotNull
    private BTreePage rootPage;
    @Nullable
    private DataPage currentDataPage;
    private long size;

    ZeeCacheTableWriter(@NotNull CachePageLoader pageLoader, @NotNull BTreePage rootPage, @NotNull CacheData tableKey, long size) {
        this.pageLoader = Objects.requireNonNull(pageLoader);
        this.rootPage = Objects.requireNonNull(rootPage);
        this.tableKey = Objects.requireNonNull(tableKey);
        this.size = size;
    }

    static ZeeCacheTableWriter create(@NotNull CachePageLoader pageLoader, @NotNull CacheData tableKey) {
        return new ZeeCacheTableWriter(pageLoader, pageLoader.newBTreeLeafPage(), tableKey, 0L);
    }

    static ZeeCacheTableWriter rootTable(@NotNull CachePageLoader pageLoader, @NotNull BTreePage rootPage, long size) {
        return new ZeeCacheTableWriter(pageLoader, rootPage, CacheData.EMPTY, size);
    }

    public CacheData tableKey() {
        return this.tableKey;
    }

    TableDesc tableDesc() {
        return TableDesc.of(this.rootPage.pageNumber(), this.size);
    }

    public ZeeCacheTableWriter add(CacheData key, CacheData value) {
        BTreeLeafPointer leafPagePtr = BTreePointer.of(this.rootPage).findLeaf(key);
        this.addInLeaf(leafPagePtr, key, value);
        ++this.size;
        return this;
    }

    private void addInLeaf(BTreeLeafPointer leafPagePtr, CacheData key, CacheData value) {
        BTreeLeafPage page = leafPagePtr.page();
        BTreeFindResult entry = page.findEntry(key);
        if (entry.found()) {
            log.warn("duplicate_entry_in_cache_table key='{}' table='{}'", (Object)key, (Object)this.tableKey);
            return;
        }
        int entryNumber = entry.entryNumber();
        BTreeLeafEntry leafEntry = BTreeLeafEntry.of(key, value);
        if (page.notEnoughSpace(leafEntry)) {
            BTreeLeafPage newPage = this.pageLoader.newBTreeLeafPage();
            int firstEntryInNewPage = page.splitTo(newPage);
            DeclareResult declare = this.declareNewPage(leafPagePtr, newPage);
            if (entryNumber < firstEntryInNewPage) {
                leafPagePtr = declare.oldPagePtr().asLeaf();
            } else {
                leafPagePtr = declare.newPagePtr().asLeaf();
                entryNumber -= firstEntryInNewPage;
            }
        }
        this.insertEntry(leafPagePtr.page(), key, value, leafEntry, entryNumber);
        if (leafPagePtr.page().isLast(entryNumber)) {
            this.updateParentLastKey(leafPagePtr);
        }
    }

    private DeclareResult declareNewPage(BTreePointer oldPagePtr, BTreePage newPage) {
        boolean insertNewPage;
        if (oldPagePtr.isRoot()) {
            BTreeNodePage newRoot = this.pageLoader.newBTreeNodePage();
            BTreeNodePointer rootPtr = BTreePointer.of(newRoot);
            BTreePointer oldPageNewPtr = rootPtr.futureChild(oldPagePtr.page(), 0);
            CacheData oldPageLastKey = oldPagePtr.lastLeaf().page().lastKey();
            this.insertChild(oldPageNewPtr, BTreeNodeEntry.of(oldPageLastKey), oldPageLastKey);
            newRoot.setLastChildPage(newPage.pageNumber());
            this.rootPage = newRoot;
            BTreePointer newPageNewPtr = rootPtr.futureChild(newPage, 1);
            return new DeclareResult(oldPageNewPtr, newPageNewPtr);
        }
        BTreeNodePointer parentPtr = oldPagePtr.parent();
        BTreeNodePage parentPage = parentPtr.page();
        BTreePointer newPagePtr = parentPtr.futureChild(newPage, oldPagePtr.entryNumber() + 1);
        if (!parentPage.isLast(oldPagePtr.entryNumber())) {
            insertNewPage = true;
        } else {
            insertNewPage = false;
            parentPage.setLastChildPage(newPage.pageNumber());
        }
        CacheData insertKey = (insertNewPage ? newPagePtr : oldPagePtr).lastLeaf().page().lastKey();
        BTreeNodeEntry insertEntry = BTreeNodeEntry.of(insertKey);
        if (parentPage.notEnoughSpace(insertEntry)) {
            BTreeNodePage newParentPage = this.pageLoader.newBTreeNodePage();
            int firstInNew = parentPage.splitTo(newParentPage);
            DeclareResult declareParent = this.declareNewPage(parentPtr, newParentPage);
            oldPagePtr = ZeeCacheTableWriter.updatePointer(oldPagePtr, firstInNew, declareParent);
            newPagePtr = ZeeCacheTableWriter.updatePointer(newPagePtr, firstInNew, declareParent);
        }
        this.insertChild(insertNewPage ? newPagePtr : oldPagePtr, insertEntry, insertKey);
        if (insertNewPage) {
            this.updateParentLastKey(oldPagePtr);
        }
        return new DeclareResult(oldPagePtr, newPagePtr);
    }

    @NotNull
    private static BTreePointer updatePointer(BTreePointer pagePtr, int firstInNew, DeclareResult declare) {
        if (pagePtr.entryNumber() < firstInNew) {
            return declare.oldPagePtr().asNode().futureChild(pagePtr.page(), pagePtr.entryNumber());
        }
        return declare.newPagePtr().asNode().futureChild(pagePtr.page(), pagePtr.entryNumber() - firstInNew);
    }

    private void updateParentLastKey(BTreePointer pagePtr) {
        if (pagePtr.isRoot()) {
            return;
        }
        BTreeNodePointer destPagePtr = pagePtr.parent();
        int entryNumber = pagePtr.entryNumber();
        while (destPagePtr.page().isLast(entryNumber)) {
            if (destPagePtr.isRoot()) {
                return;
            }
            entryNumber = destPagePtr.entryNumber();
            destPagePtr = destPagePtr.parent();
        }
        BTreeLeafPage leafPage = pagePtr.lastLeaf().page();
        CacheData key = leafPage.lastKey();
        DataEntry srcKeyEntry = key.entry();
        CacheAddress more = leafPage.more(srcKeyEntry);
        BTreeNodePage destPage = destPagePtr.page();
        BTreeNodeEntry destEntry = destPage.entry(entryNumber);
        int delta = srcKeyEntry.localEntryLength() - destEntry.keyEntry().localEntryLength();
        if (delta > destPage.freeSpace()) {
            BTreeNodePage newDestSiblingPage = this.pageLoader.newBTreeNodePage();
            int firstInNew = destPage.splitTo(newDestSiblingPage);
            DeclareResult declare = this.declareNewPage(destPagePtr, newDestSiblingPage);
            if (entryNumber < firstInNew) {
                destPagePtr = declare.oldPagePtr().asNode();
            } else {
                destPagePtr = declare.newPagePtr().asNode();
                entryNumber -= firstInNew;
            }
            destPage = destPagePtr.page();
            if (destPage.isLast(entryNumber)) {
                this.updateParentLastKey(destPagePtr);
                return;
            }
        }
        destPage.updateKey(entryNumber, more, key.byteIterator());
    }

    private void insertEntry(BTreeLeafPage leafPage, CacheData key, CacheData value, BTreeLeafEntry entry, int entryNumber) {
        leafPage.insertNewEntry(entryNumber, entry);
        this.writeWithOverflow(entry.keyEntry(), key.byteIterator(), leafPage::writeLocalData);
        this.writeWithOverflow(entry.valueEntry(), value.byteIterator(), leafPage::writeLocalData);
    }

    private void insertChild(BTreePointer insertPagePtr, BTreeNodeEntry entry, CacheData key) {
        BTreeNodePage nodePage = insertPagePtr.parent().page();
        BTreePage childPage = insertPagePtr.page();
        int entryNumber = insertPagePtr.entryNumber();
        nodePage.insertNewEntry(entryNumber, entry);
        this.writeWithOverflow(entry.keyEntry(), key.byteIterator(), nodePage::writeLocalData);
        nodePage.setChild(entry, childPage.pageNumber());
    }

    private void writeWithOverflow(DataEntry entry, ByteIterator data, LocalDataWriter writeAction) {
        CacheAddress moreAddress;
        DataPage morePage;
        if (entry.dataLength() != data.remaining()) {
            throw new IllegalArgumentException("Different entry (" + entry.dataLength() + ") and data (" + data.remaining() + ") length.");
        }
        if (entry.overflow()) {
            morePage = this.currentDataPage();
            moreAddress = CacheAddress.of(morePage.pageNumber(), morePage.freeSpaceIndex());
        } else {
            morePage = null;
            moreAddress = CacheAddress.INVALID;
        }
        writeAction.writeLocalData(entry, moreAddress, data);
        while (data.hasNext()) {
            DataPage dataPage = morePage;
            if (data.remaining() > dataPage.freePayloadSpace()) {
                morePage = this.newCurrentDataPage();
                moreAddress = CacheAddress.of(morePage.pageNumber(), morePage.freeSpaceIndex());
            } else {
                morePage = null;
                moreAddress = CacheAddress.INVALID;
            }
            dataPage.write(data, moreAddress);
        }
    }

    private DataPage currentDataPage() {
        if (this.currentDataPage == null || !this.currentDataPage.hasMoreSpace()) {
            this.currentDataPage = this.pageLoader.newDataPage();
        }
        return this.currentDataPage;
    }

    private DataPage newCurrentDataPage() {
        this.currentDataPage = this.pageLoader.newDataPage();
        return this.currentDataPage;
    }

    public ZeeCacheTableWriter add(CacheEntry entry) {
        return this.add(entry.key(), entry.value());
    }

    public ZeeCacheTableWriter add(CacheData key, ByteBuffer value) {
        return this.add(key, CacheData.of(value));
    }

    public ZeeCacheTableWriter add(CacheData key, byte[] value) {
        return this.add(key, ByteBuffer.wrap(value));
    }

    public ZeeCacheTableWriter add(CacheData key, String value) {
        return this.add(key, value.getBytes(StandardCharsets.UTF_8));
    }

    public ZeeCacheTableWriter add(String key, String value) {
        return this.add(CacheData.of(key), value.getBytes(StandardCharsets.UTF_8));
    }

    public ZeeCacheTableWriter add(String key, byte[] value) {
        return this.add(CacheData.of(key), value);
    }

    public ZeeCacheTableWriter add(byte[] key, byte[] value) {
        return this.add(CacheData.of(key), value);
    }

    private static final class DeclareResult {
        private final BTreePointer oldPagePtr;
        private final BTreePointer newPagePtr;

        private DeclareResult(BTreePointer oldPagePtr, BTreePointer newPagePtr) {
            this.oldPagePtr = oldPagePtr;
            this.newPagePtr = newPagePtr;
        }

        public BTreePointer oldPagePtr() {
            return this.oldPagePtr;
        }

        public BTreePointer newPagePtr() {
            return this.newPagePtr;
        }
    }

    private static interface LocalDataWriter {
        public void writeLocalData(DataEntry var1, CacheAddress var2, ByteIterator var3);
    }
}

