/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Objects;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataPage;

public abstract class ByteIterator {
    private static final ByteIterator EMPTY = new OfEmpty();

    public abstract boolean hasNext();

    public abstract byte next();

    public abstract int remaining();

    private ByteIterator() {
    }

    static ByteIterator of(byte[] value) {
        return new OfArray(value);
    }

    static ByteIterator of(CachePageLoader pageLoader, CacheAddress next, ByteBuffer firstBytes, int length) {
        return new OfPage(pageLoader, next, firstBytes, length);
    }

    static ByteIterator empty() {
        return EMPTY;
    }

    private static final class OfEmpty
    extends ByteIterator {
        private OfEmpty() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int remaining() {
            return 0;
        }

        @Override
        public byte next() {
            throw new NoSuchElementException("empty");
        }
    }

    private static final class OfPage
    extends ByteIterator {
        private final CachePageLoader pageLoader;
        private CacheAddress more;
        private ByteBuffer buffer;
        private int remaining;

        OfPage(CachePageLoader pageLoader, CacheAddress more, ByteBuffer firstBytes, int length) {
            this.pageLoader = pageLoader;
            this.more = more;
            this.buffer = firstBytes;
            this.remaining = length;
        }

        @Override
        public boolean hasNext() {
            if (this.remaining <= 0) {
                return false;
            }
            if (this.buffer.hasRemaining()) {
                return true;
            }
            if (!this.more.isValid()) {
                return false;
            }
            DataPage nextPage = this.pageLoader.page(this.more.page(), DataPage.class);
            int len = nextPage.length(this.more.index());
            if (this.remaining < len) {
                len = this.remaining;
            }
            if (this.buffer.capacity() < len) {
                this.buffer = ByteBuffer.allocate(len);
            } else {
                this.buffer.position(0);
                this.buffer.limit(len);
            }
            nextPage.read(this.more.index(), this.buffer);
            this.more = nextPage.more(this.more.index());
            this.buffer.flip();
            return true;
        }

        @Override
        public int remaining() {
            return this.remaining;
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more bytes");
            }
            --this.remaining;
            return this.buffer.get();
        }
    }

    private static final class OfArray
    extends ByteIterator {
        private final byte[] value;
        int index;

        public OfArray(byte[] value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.value.length;
        }

        @Override
        public int remaining() {
            return this.value.length - this.index;
        }

        @Override
        public byte next() {
            if (this.index >= this.value.length) {
                throw new NoSuchElementException("No more bytes");
            }
            return this.value[this.index++];
        }
    }
}

